/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record BigQueryInsertTableHandle(RemoteTableName remoteTableName, List<String> columnNames, List<Type> columnTypes, String temporaryTableName, String pageSinkIdColumnName) implements ConnectorInsertTableHandle
{
    public BigQueryInsertTableHandle {
        Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must have the same size");
        Objects.requireNonNull(temporaryTableName, "temporaryTableName is null");
        Objects.requireNonNull(pageSinkIdColumnName, "pageSinkIdColumnName is null");
    }

    @JsonIgnore
    public RemoteTableName getTemporaryRemoteTableName() {
        return new RemoteTableName(this.remoteTableName.projectId(), this.remoteTableName.datasetName(), this.temporaryTableName);
    }
}

