/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.net.URI;
import java.util.Optional;

public class BigQueryProxyConfig {
    private URI uri;
    private Optional<String> username = Optional.empty();
    private Optional<String> password = Optional.empty();
    private File keystorePath;
    private String keystorePassword;
    private File truststorePath;
    private String truststorePassword;

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    @ConfigDescription(value="Proxy URI (host and port only)")
    @Config(value="bigquery.rpc-proxy.uri")
    public BigQueryProxyConfig setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    @ConfigDescription(value="Username used to authenticate against proxy")
    @Config(value="bigquery.rpc-proxy.username")
    public BigQueryProxyConfig setUsername(String username) {
        this.username = Optional.ofNullable(username);
        return this;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    @ConfigSecuritySensitive
    @ConfigDescription(value="Password used to authenticate against proxy")
    @Config(value="bigquery.rpc-proxy.password")
    public BigQueryProxyConfig setPassword(String password) {
        this.password = Optional.ofNullable(password);
        return this;
    }

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="bigquery.rpc-proxy.keystore-path")
    @ConfigDescription(value="Path to a Java keystore file")
    public BigQueryProxyConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="bigquery.rpc-proxy.keystore-password")
    @ConfigDescription(value="Password to a Java keystore file")
    @ConfigSecuritySensitive
    public BigQueryProxyConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<@FileExists File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="bigquery.rpc-proxy.truststore-path")
    @ConfigDescription(value="Path to a Java truststore file")
    public BigQueryProxyConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="bigquery.rpc-proxy.truststore-password")
    @ConfigDescription(value="Password to a Java truststore file")
    @ConfigSecuritySensitive
    public BigQueryProxyConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    @AssertTrue(message="BigQuery RPC proxy URI cannot specify path")
    public @AssertTrue(message="BigQuery RPC proxy URI cannot specify path") boolean isUriValid() {
        return Strings.isNullOrEmpty((String)this.uri.getPath());
    }

    @AssertTrue(message="bigquery.rpc-proxy.username was set but bigquery.rpc-proxy.password is empty")
    public @AssertTrue(message="bigquery.rpc-proxy.username was set but bigquery.rpc-proxy.password is empty") boolean isPasswordNonEmptyIfUserProvided() {
        return this.password.isPresent() || this.username.isEmpty();
    }

    @AssertTrue(message="bigquery.rpc-proxy.password was set but bigquery.rpc-proxy.username is empty")
    public @AssertTrue(message="bigquery.rpc-proxy.password was set but bigquery.rpc-proxy.username is empty") boolean isUserNotEmptyIfPasswordProvided() {
        return this.username.isPresent() || this.password.isEmpty();
    }

    private static ConfigurationException exception(String message) {
        return new ConfigurationException((Iterable)ImmutableList.of((Object)new Message(message)));
    }
}

