/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.BigQueryUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class BigQueryQueryPageSource
implements ConnectorPageSource {
    private static final long MAX_PAGE_ROW_COUNT = 8192L;
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd().toFormatter();
    private final BigQueryTypeManager typeManager;
    private final List<BigQueryColumnHandle> columnHandles;
    private final PageBuilder pageBuilder;
    private final boolean isQueryFunction;
    private final AtomicLong readTimeNanos = new AtomicLong();
    private CompletableFuture<TableResult> tableResultFuture;
    private TableResult tableResult;
    private boolean finished;

    public BigQueryQueryPageSource(ConnectorSession session, BigQueryTypeManager typeManager, BigQueryClient client, ExecutorService executor, BigQueryTableHandle table, List<BigQueryColumnHandle> columnHandles, Optional<String> filter) {
        Objects.requireNonNull(session, "session is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(table, "table is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        Objects.requireNonNull(filter, "filter is null");
        this.pageBuilder = new PageBuilder((List)columnHandles.stream().map(BigQueryColumnHandle::trinoType).collect(ImmutableList.toImmutableList()));
        this.isQueryFunction = table.relationHandle() instanceof BigQueryQueryRelationHandle;
        String sql = this.buildSql(table, client.getProjectId(), (List<BigQueryColumnHandle>)ImmutableList.copyOf(columnHandles), filter);
        this.tableResultFuture = CompletableFuture.supplyAsync(() -> {
            long start = System.nanoTime();
            TableResult result = client.executeQuery(session, sql, 8192L);
            this.readTimeNanos.addAndGet(System.nanoTime() - start);
            return result;
        }, executor);
    }

    private String buildSql(BigQueryTableHandle table, String projectId, List<BigQueryColumnHandle> columns, Optional<String> filter) {
        if (this.isQueryFunction) {
            BigQueryQueryRelationHandle queryRelationHandle = (BigQueryQueryRelationHandle)table.relationHandle();
            return BigQueryUtil.buildNativeQuery(queryRelationHandle.getQuery(), filter, table.limit());
        }
        TableId tableId = TableId.of((String)projectId, (String)table.asPlainTable().getRemoteTableName().datasetName(), (String)table.asPlainTable().getRemoteTableName().tableName());
        return BigQueryClient.selectSql(tableId, (List<BigQueryColumnHandle>)ImmutableList.copyOf(columns), filter, table.limit());
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public SourcePage getNextSourcePage() {
        long start;
        Verify.verify((boolean)this.pageBuilder.isEmpty());
        if (!this.tableResultFuture.isDone()) {
            return null;
        }
        if (this.tableResult == null) {
            this.tableResult = (TableResult)MoreFutures.getFutureValue(this.tableResultFuture);
        } else if (this.tableResult.hasNextPage()) {
            start = System.nanoTime();
            this.tableResult = this.tableResult.getNextPage();
            this.readTimeNanos.addAndGet(System.nanoTime() - start);
        } else {
            this.finished = true;
            return null;
        }
        start = System.nanoTime();
        ImmutableList values = ImmutableList.copyOf((Iterable)this.tableResult.getValues());
        this.finished = !this.tableResult.hasNextPage();
        this.readTimeNanos.addAndGet(System.nanoTime() - start);
        for (FieldValueList record : values) {
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnHandles.size(); ++column) {
                BigQueryColumnHandle columnHandle = this.columnHandles.get(column);
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                FieldValue fieldValue = this.isQueryFunction ? record.get(columnHandle.name()) : record.get(column);
                this.appendTo(columnHandle.trinoType(), fieldValue, output);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return SourcePage.create((Page)page);
    }

    private void appendTo(Type type, FieldValue value, BlockBuilder output) {
        block16: {
            if (value == null || value.isNull()) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, value.getBooleanValue());
                    break block16;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals((Object)BigintType.BIGINT)) {
                        type.writeLong(output, value.getLongValue());
                        break block16;
                    }
                    if (type.equals((Object)IntegerType.INTEGER)) {
                        type.writeLong(output, value.getLongValue());
                        break block16;
                    }
                    if (type.equals((Object)DateType.DATE)) {
                        type.writeLong(output, LocalDate.parse(value.getStringValue()).toEpochDay());
                        break block16;
                    }
                    if (type.equals((Object)TimeType.TIME_MICROS)) {
                        LocalTime time = LocalTime.parse(value.getStringValue(), TIME_FORMATTER);
                        long nanosOfDay = time.toNanoOfDay();
                        Verify.verify((nanosOfDay < 86400000000000L ? 1 : 0) != 0, (String)"Invalid value of nanosOfDay: %s", (long)nanosOfDay);
                        long picosOfDay = nanosOfDay * 1000L;
                        long rounded = Timestamps.round((long)picosOfDay, (int)(12 - TimeType.TIME_MICROS.getPrecision()));
                        if (rounded == 86400000000000000L) {
                            rounded = 0L;
                        }
                        type.writeLong(output, rounded);
                        break block16;
                    }
                    if (type.equals((Object)TimestampType.TIMESTAMP_MICROS)) {
                        type.writeLong(output, BigQueryTypeManager.toTrinoTimestamp(value.getStringValue()));
                        break block16;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, value.getDoubleValue());
                    break block16;
                }
                if (type.getJavaType() == Int128.class) {
                    DecimalType decimalType = (DecimalType)type;
                    Verify.verify((!decimalType.isShort() ? 1 : 0) != 0, (String)"The type should be long decimal", (Object[])new Object[0]);
                    BigDecimal decimal = value.getNumericValue();
                    type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)decimal, (int)decimalType.getScale()));
                    break block16;
                }
                if (javaType == Slice.class) {
                    this.writeSlice(output, type, value);
                    break block16;
                }
                if (type instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)type;
                    ((ArrayBlockBuilder)output).buildEntry(elementBuilder -> {
                        Type elementType = arrayType.getElementType();
                        for (FieldValue element : value.getRepeatedValue()) {
                            this.appendTo(elementType, element, elementBuilder);
                        }
                    });
                    break block16;
                }
                if (type instanceof RowType) {
                    RowType rowType = (RowType)type;
                    FieldValueList record = value.getRecordValue();
                    List fields = rowType.getFields();
                    ((RowBlockBuilder)output).buildEntry(fieldBuilders -> {
                        for (int index = 0; index < fields.size(); ++index) {
                            this.appendTo(((RowType.Field)fields.get(index)).getType(), record.get(index), (BlockBuilder)fieldBuilders.get(index));
                        }
                    });
                    break block16;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type));
            }
            catch (ClassCastException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unhandled type for %s: %s", javaType.getSimpleName(), type), (Throwable)e);
            }
        }
    }

    private void writeSlice(BlockBuilder output, Type type, FieldValue value) {
        if (type instanceof VarcharType || this.typeManager.isJsonType(type)) {
            type.writeSlice(output, Slices.utf8Slice((String)value.getStringValue()));
        } else if (type instanceof VarbinaryType) {
            type.writeSlice(output, Slices.wrappedBuffer((byte[])value.getBytesValue()));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + String.valueOf(type.getTypeSignature()));
        }
    }

    public void close() {
        this.tableResultFuture.cancel(true);
        this.tableResult = null;
    }

    public CompletableFuture<?> isBlocked() {
        return this.tableResultFuture;
    }
}

