/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Set;

public class BigQueryReadClientFactory {
    private final Set<BigQueryOptionsConfigurer> configurers;

    @Inject
    public BigQueryReadClientFactory(Set<BigQueryOptionsConfigurer> configurers) {
        this.configurers = Objects.requireNonNull(configurers, "configurers is null");
    }

    BigQueryReadClient create(ConnectorSession session) {
        BigQueryReadSettings.Builder builder = (BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)BigQueryReadSettings.defaultGrpcTransportProviderBuilder().build());
        for (BigQueryOptionsConfigurer configurer : this.configurers) {
            builder = configurer.configure(builder, session);
        }
        try {
            return BigQueryReadClient.create((BigQueryReadSettings)builder.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating BigQueryReadClient", e);
        }
    }
}

