/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryFilterQueryBuilder;
import io.trino.plugin.bigquery.BigQueryNamedRelationHandle;
import io.trino.plugin.bigquery.BigQueryQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQuerySessionProperties;
import io.trino.plugin.bigquery.BigQuerySplit;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryUtil;
import io.trino.plugin.bigquery.ReadSessionCreator;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.predicate.TupleDomain;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

public class BigQuerySplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(BigQuerySplitSource.class);
    private final ConnectorSession session;
    private final BigQueryTableHandle table;
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final boolean viewEnabled;
    private final boolean arrowSerializationEnabled;
    private final Duration viewExpiration;
    private final NodeManager nodeManager;
    private final int maxReadRowsRetries;
    @Nullable
    private List<BigQuerySplit> splits;
    private int offset;

    public BigQuerySplitSource(ConnectorSession session, BigQueryTableHandle table, BigQueryClientFactory bigQueryClientFactory, BigQueryReadClientFactory bigQueryReadClientFactory, boolean viewEnabled, boolean arrowSerializationEnabled, Duration viewExpiration, NodeManager nodeManager, int maxReadRowsRetries) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory cannot be null");
        this.bigQueryReadClientFactory = Objects.requireNonNull(bigQueryReadClientFactory, "bigQueryReadClientFactory cannot be null");
        this.viewEnabled = viewEnabled;
        this.arrowSerializationEnabled = arrowSerializationEnabled;
        this.viewExpiration = Objects.requireNonNull(viewExpiration, "viewExpiration is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager cannot be null");
        this.maxReadRowsRetries = maxReadRowsRetries;
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        if (this.splits == null) {
            this.splits = this.getSplits(this.session, this.table);
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(this.prepareNextBatch(maxSize), this.isFinished()));
    }

    private List<ConnectorSplit> prepareNextBatch(int maxSize) {
        Objects.requireNonNull(this.splits, "splits is null");
        int nextOffset = Math.min(this.splits.size(), this.offset + maxSize);
        List results = (List)this.splits.subList(this.offset, nextOffset).stream().map(ConnectorSplit.class::cast).collect(ImmutableList.toImmutableList());
        this.offset = nextOffset;
        return results;
    }

    public boolean isFinished() {
        return this.splits != null && this.offset >= this.splits.size();
    }

    public void close() {
        this.splits = null;
    }

    private List<BigQuerySplit> getSplits(ConnectorSession session, BigQueryTableHandle bigQueryTableHandle) {
        TableDefinition.Type tableType;
        TableId remoteTableId;
        boolean useStorageApi;
        TupleDomain<ColumnHandle> tableConstraint = bigQueryTableHandle.constraint();
        Optional<String> filter = BigQueryFilterQueryBuilder.buildFilter(tableConstraint);
        OptionalLong limit = bigQueryTableHandle.limit();
        if (bigQueryTableHandle.isQueryRelation()) {
            BigQueryQueryRelationHandle bigQueryQueryRelationHandle = bigQueryTableHandle.getRequiredQueryRelation();
            List<BigQueryColumnHandle> columns = bigQueryTableHandle.projectedColumns().orElse((List<BigQueryColumnHandle>)ImmutableList.of());
            useStorageApi = bigQueryQueryRelationHandle.isUseStorageApi();
            if (!useStorageApi) {
                log.debug("Using Rest API for running query: %s", new Object[]{bigQueryQueryRelationHandle.getQuery()});
                return List.of(BigQuerySplit.forViewStream(columns, filter));
            }
            String query = BigQueryUtil.buildNativeQuery(bigQueryQueryRelationHandle.getQuery(), filter, limit);
            TableId destinationTable = bigQueryQueryRelationHandle.getDestinationTableName().toTableId();
            TableInfo tableInfo = new ViewMaterializationCache.DestinationTableBuilder(this.bigQueryClientFactory.create(session), this.viewExpiration, query, destinationTable).get();
            log.debug("Using Storage API for running query: %s", new Object[]{query});
            remoteTableId = tableInfo.getTableId();
            tableType = tableInfo.getDefinition().getType();
        } else {
            BigQueryNamedRelationHandle namedRelation = bigQueryTableHandle.getRequiredNamedRelation();
            remoteTableId = namedRelation.getRemoteTableName().toTableId();
            tableType = TableDefinition.Type.valueOf((String)namedRelation.getType());
            useStorageApi = namedRelation.isUseStorageApi();
        }
        return BigQuerySplitSource.emptyProjectionIsRequired(bigQueryTableHandle.projectedColumns()) ? this.createEmptyProjection(session, tableType, remoteTableId, filter, limit) : this.readFromBigQuery(session, tableType, remoteTableId, bigQueryTableHandle.projectedColumns(), tableConstraint, useStorageApi);
    }

    private static boolean emptyProjectionIsRequired(Optional<List<BigQueryColumnHandle>> projectedColumns) {
        return projectedColumns.isPresent() && projectedColumns.get().isEmpty();
    }

    private List<BigQuerySplit> readFromBigQuery(ConnectorSession session, TableDefinition.Type type, TableId remoteTableId, Optional<List<BigQueryColumnHandle>> projectedColumns, TupleDomain<ColumnHandle> tableConstraint, boolean useStorageApi) {
        Preconditions.checkArgument((projectedColumns.isPresent() && projectedColumns.get().size() > 0 ? 1 : 0) != 0, (Object)"Projected column is empty");
        Optional<String> filter = BigQueryFilterQueryBuilder.buildFilter(tableConstraint);
        log.debug("readFromBigQuery(tableId=%s, projectedColumns=%s, filter=[%s])", new Object[]{remoteTableId, projectedColumns, filter});
        List<BigQueryColumnHandle> columns = projectedColumns.get();
        List<String> projectedColumnsNames = BigQuerySplitSource.getProjectedColumnNames(columns);
        ImmutableList.Builder projectedColumnHandles = ImmutableList.builder();
        projectedColumnHandles.addAll(columns);
        if (!useStorageApi) {
            return ImmutableList.of((Object)BigQuerySplit.forViewStream(columns, filter));
        }
        if (type == TableDefinition.Type.VIEW || type == TableDefinition.Type.MATERIALIZED_VIEW) {
            tableConstraint.getDomains().ifPresent(domains -> domains.keySet().stream().map(BigQueryColumnHandle.class::cast).filter(column -> !projectedColumnsNames.contains(column.name())).forEach(arg_0 -> ((ImmutableList.Builder)projectedColumnHandles).add(arg_0)));
        }
        ReadSession readSession = this.createReadSession(session, remoteTableId, (List<BigQueryColumnHandle>)ImmutableList.copyOf((Collection)projectedColumnHandles.build()), filter);
        String schemaString = this.getSchemaAsString(readSession);
        return (List)readSession.getStreamsList().stream().map(stream -> BigQuerySplit.forStream(stream.getName(), schemaString, columns, OptionalInt.of(stream.getSerializedSize()))).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    ReadSession createReadSession(ConnectorSession session, TableId remoteTableId, List<BigQueryColumnHandle> columns, Optional<String> filter) {
        ReadSessionCreator readSessionCreator = new ReadSessionCreator(this.bigQueryClientFactory, this.bigQueryReadClientFactory, this.viewEnabled, this.arrowSerializationEnabled, this.viewExpiration, this.maxReadRowsRetries, BigQuerySessionProperties.getMaxParallelism(session));
        return readSessionCreator.create(session, remoteTableId, columns, filter, this.nodeManager.getRequiredWorkerNodes().size());
    }

    private static List<String> getProjectedColumnNames(List<BigQueryColumnHandle> columns) {
        return (List)columns.stream().map(BigQueryColumnHandle::name).collect(ImmutableList.toImmutableList());
    }

    private List<BigQuerySplit> createEmptyProjection(ConnectorSession session, TableDefinition.Type tableType, TableId remoteTableId, Optional<String> filter, OptionalLong limit) {
        if (!BigQueryClient.TABLE_TYPES.containsKey(tableType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table type: " + String.valueOf(tableType));
        }
        String sql = "SELECT COUNT(*) FROM (%s)".formatted(BigQueryClient.selectSql(remoteTableId, "true", filter, limit));
        return this.createEmptyProjection(session, sql);
    }

    private List<BigQuerySplit> createEmptyProjection(ConnectorSession session, String sql) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("createEmptyProjection(sql=%s)", new Object[]{sql});
        try {
            TableResult result = client.executeQuery(session, sql);
            long numberOfRows = ((FieldValue)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)result.iterateAll())))).getLongValue();
            return ImmutableList.of((Object)BigQuerySplit.emptyProjection(numberOfRows));
        }
        catch (BigQueryException e) {
            throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_FAILED_TO_EXECUTE_QUERY, "Failed to compute empty projection", (Throwable)e);
        }
    }

    private String getSchemaAsString(ReadSession readSession) {
        if (this.arrowSerializationEnabled) {
            return BigQuerySplitSource.deserializeArrowSchema(readSession.getArrowSchema().getSerializedSchema());
        }
        return readSession.getAvroSchema().getSchema();
    }

    private static String deserializeArrowSchema(ByteString serializedSchema) {
        try {
            return MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(serializedSchema.toByteArray()))).toJson();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

