/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.base.Preconditions;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryNamedRelationHandle;
import io.trino.plugin.bigquery.BigQueryQueryRelationHandle;
import io.trino.plugin.bigquery.BigQueryRelationHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public record BigQueryTableHandle(BigQueryRelationHandle relationHandle, TupleDomain<ColumnHandle> constraint, Optional<List<BigQueryColumnHandle>> projectedColumns, OptionalLong limit) implements ConnectorTableHandle
{
    public BigQueryTableHandle {
        Objects.requireNonNull(relationHandle, "relationHandle is null");
        Objects.requireNonNull(constraint, "constraint is null");
        Objects.requireNonNull(projectedColumns, "projectedColumns is null");
        Objects.requireNonNull(limit, "limit is null");
    }

    @JsonIgnore
    public BigQueryNamedRelationHandle getRequiredNamedRelation() {
        Preconditions.checkState((boolean)this.isNamedRelation(), (String)"The table handle does not represent a named relation: %s", (Object)this);
        return (BigQueryNamedRelationHandle)this.relationHandle;
    }

    @JsonIgnore
    public BigQueryQueryRelationHandle getRequiredQueryRelation() {
        Preconditions.checkState((boolean)this.isQueryRelation(), (String)"The table handle does not represent a query relation: %s", (Object)this);
        return (BigQueryQueryRelationHandle)this.relationHandle;
    }

    @JsonIgnore
    public boolean isSynthetic() {
        return !this.isNamedRelation();
    }

    @JsonIgnore
    public boolean isNamedRelation() {
        return this.relationHandle instanceof BigQueryNamedRelationHandle;
    }

    @JsonIgnore
    public boolean isQueryRelation() {
        return this.relationHandle instanceof BigQueryQueryRelationHandle;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.relationHandle);
        if (this.constraint.isNone()) {
            builder.append(" constraint=FALSE");
        } else if (!this.constraint.isAll()) {
            builder.append(" constraint on ");
            builder.append(((Map)this.constraint.getDomains().orElseThrow()).keySet().stream().map(columnHandle -> ((BigQueryColumnHandle)columnHandle).name()).collect(Collectors.joining(", ", "[", "]")));
        }
        this.projectedColumns.ifPresent(columns -> builder.append(" columns=").append(columns));
        this.limit.ifPresent(value -> builder.append(" limit=").append(value));
        return builder.toString();
    }

    public BigQueryNamedRelationHandle asPlainTable() {
        Preconditions.checkState((!this.isSynthetic() ? 1 : 0) != 0, (String)"The table handle does not represent a plain table: %s", (Object)this);
        return this.getRequiredNamedRelation();
    }

    BigQueryTableHandle withConstraint(TupleDomain<ColumnHandle> newConstraint) {
        return new BigQueryTableHandle(this.relationHandle, newConstraint, this.projectedColumns, this.limit);
    }

    public BigQueryTableHandle withProjectedColumns(List<BigQueryColumnHandle> newProjectedColumns) {
        return new BigQueryTableHandle(this.relationHandle, this.constraint, Optional.of(newProjectedColumns), this.limit);
    }

    public BigQueryTableHandle withLimit(long limit) {
        return new BigQueryTableHandle(this.relationHandle, this.constraint, this.projectedColumns, OptionalLong.of(limit));
    }

    public static Optional<BigQueryPartitionType> getPartitionType(TableDefinition definition) {
        if (definition instanceof StandardTableDefinition) {
            StandardTableDefinition standardTableDefinition = (StandardTableDefinition)definition;
            RangePartitioning rangePartition = standardTableDefinition.getRangePartitioning();
            if (rangePartition != null) {
                return Optional.of(BigQueryPartitionType.RANGE);
            }
            TimePartitioning timePartition = standardTableDefinition.getTimePartitioning();
            if (timePartition != null) {
                if (timePartition.getField() != null) {
                    return Optional.of(BigQueryPartitionType.TIME);
                }
                return Optional.of(BigQueryPartitionType.INGESTION);
            }
        }
        return Optional.empty();
    }

    public static enum BigQueryPartitionType {
        TIME,
        INGESTION,
        RANGE;

    }
}

