/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.TableDefinition;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.trino.plugin.bigquery.BigQueryPseudoColumn;
import io.trino.plugin.bigquery.RemoteTableName;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public final class BigQueryUtil {
    private static final String QUOTE = "`";
    private static final String ESCAPED_QUOTE = "``";
    private static final Set<String> INTERNAL_ERROR_MESSAGES = ImmutableSet.of((Object)"HTTP/2 error code: INTERNAL_ERROR", (Object)"Connection closed with unknown cause", (Object)"Received unexpected EOS on DATA frame from server", (Object)"INTERNAL: request failed: internal error");

    private BigQueryUtil() {
    }

    public static boolean isRetryable(Throwable cause) {
        return Throwables.getCausalChain((Throwable)cause).stream().anyMatch(BigQueryUtil::isRetryableInternalError);
    }

    private static boolean isRetryableInternalError(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            return statusRuntimeException.getStatus().getCode() == Status.Code.INTERNAL && INTERNAL_ERROR_MESSAGES.stream().anyMatch(message -> statusRuntimeException.getMessage().contains((CharSequence)message));
        }
        return false;
    }

    public static String buildNativeQuery(String nativeQuery, Optional<String> filter, OptionalLong limit) {
        String queryString = filter.map(s -> "SELECT * FROM (" + nativeQuery + ") WHERE " + s).orElse(nativeQuery);
        if (limit.isPresent()) {
            return "SELECT * FROM (" + queryString + ") LIMIT " + limit.getAsLong();
        }
        return queryString;
    }

    public static BigQueryException convertToBigQueryException(BigQueryError error) {
        return new BigQueryException(0, error.getMessage(), error);
    }

    public static String toBigQueryColumnName(String columnName) {
        Optional<BigQueryPseudoColumn> pseudoColumn = Arrays.stream(BigQueryPseudoColumn.values()).filter(column -> column.getTrinoColumnName().equals(columnName)).findFirst();
        if (pseudoColumn.isPresent()) {
            return pseudoColumn.get().getBigqueryColumnName();
        }
        return columnName;
    }

    public static boolean isWildcardTable(TableDefinition.Type type, String tableName) {
        return type == TableDefinition.Type.TABLE && tableName.contains("*");
    }

    public static String quote(String name) {
        return QUOTE + name.replace(QUOTE, ESCAPED_QUOTE) + QUOTE;
    }

    public static String quoted(RemoteTableName table) {
        return String.format("%s.%s.%s", BigQueryUtil.quote(table.projectId()), BigQueryUtil.quote(table.datasetName()), BigQueryUtil.quote(table.tableName()));
    }
}

