/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.Optional;

public class CredentialsOptionsConfigurer
implements BigQueryOptionsConfigurer {
    private final BigQueryCredentialsSupplier credentialsSupplier;
    private final Optional<String> configParentProjectId;

    @Inject
    public CredentialsOptionsConfigurer(BigQueryConfig bigQueryConfig, BigQueryCredentialsSupplier credentialsSupplier) {
        this.configParentProjectId = bigQueryConfig.getParentProjectId();
        this.credentialsSupplier = Objects.requireNonNull(credentialsSupplier, "credentialsSupplier is null");
    }

    @Override
    public BigQueryOptions.Builder configure(BigQueryOptions.Builder builder, ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        String parentProjectId = CredentialsOptionsConfigurer.resolveProjectId(this.configParentProjectId, credentials);
        credentials.ifPresent(arg_0 -> ((BigQueryOptions.Builder)builder).setCredentials(arg_0));
        builder.setProjectId(parentProjectId);
        return builder;
    }

    @Override
    public BigQueryReadSettings.Builder configure(BigQueryReadSettings.Builder builder, ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        credentials.ifPresent(value -> builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)value)));
        return builder;
    }

    @Override
    public BigQueryWriteSettings.Builder configure(BigQueryWriteSettings.Builder builder, ConnectorSession session) {
        Optional<Credentials> credentials = this.credentialsSupplier.getCredentials(session);
        credentials.ifPresent(value -> builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)value)));
        return builder;
    }

    @VisibleForTesting
    static String resolveProjectId(Optional<String> configProjectId, Optional<Credentials> credentials) {
        return configProjectId.orElseGet(() -> credentials.filter(ServiceAccountCredentials.class::isInstance).map(ServiceAccountCredentials.class::cast).map(ServiceAccountCredentials::getProjectId).orElseGet(ServiceOptions::getDefaultProjectId));
    }
}

