/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryMetadata;
import io.trino.plugin.bigquery.BigQueryMetadataFactory;
import io.trino.plugin.bigquery.BigQueryTransactionHandle;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.BigQueryWriteClientFactory;
import java.util.Objects;

public class DefaultBigQueryMetadataFactory
implements BigQueryMetadataFactory {
    private final BigQueryClientFactory bigQueryClient;
    private final BigQueryWriteClientFactory writeClientFactory;
    private final ListeningExecutorService executorService;
    private final BigQueryTypeManager typeManager;
    private final boolean isLegacyMetadataListing;

    @Inject
    public DefaultBigQueryMetadataFactory(BigQueryClientFactory bigQueryClient, BigQueryWriteClientFactory writeClientFactory, BigQueryTypeManager typeManager, ListeningExecutorService executorService, BigQueryConfig config) {
        this.bigQueryClient = Objects.requireNonNull(bigQueryClient, "bigQueryClient is null");
        this.writeClientFactory = Objects.requireNonNull(writeClientFactory, "writeClientFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.isLegacyMetadataListing = config.isLegacyMetadataListing();
    }

    @Override
    public BigQueryMetadata create(BigQueryTransactionHandle transaction) {
        return new BigQueryMetadata(this.bigQueryClient, this.writeClientFactory, this.typeManager, this.executorService, this.isLegacyMetadataListing);
    }
}

