/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.trino.plugin.bigquery.BigQueryGrpcOptionsConfigurer;
import io.trino.plugin.bigquery.ProxyTransportFactory;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;

public class ProxyOptionsConfigurer
implements BigQueryGrpcOptionsConfigurer {
    private final ProxyTransportFactory proxyTransportFactory;

    @Inject
    public ProxyOptionsConfigurer(ProxyTransportFactory proxyTransportFactory) {
        this.proxyTransportFactory = Objects.requireNonNull(proxyTransportFactory, "proxyTransportFactory is null");
    }

    @Override
    public BigQueryOptions.Builder configure(BigQueryOptions.Builder builder, ConnectorSession session) {
        return builder.setTransportOptions((TransportOptions)this.proxyTransportFactory.getTransportOptions());
    }

    @Override
    public InstantiatingGrpcChannelProvider.Builder configure(InstantiatingGrpcChannelProvider.Builder channelBuilder, ConnectorSession session) {
        return channelBuilder.setChannelConfigurator(this::configureChannel);
    }

    private ManagedChannelBuilder configureChannel(ManagedChannelBuilder managedChannelBuilder) {
        Preconditions.checkState((boolean)(managedChannelBuilder instanceof NettyChannelBuilder), (Object)"Expected ManagedChannelBuilder to be provider by Netty");
        NettyChannelBuilder nettyChannelBuilder = (NettyChannelBuilder)managedChannelBuilder;
        this.proxyTransportFactory.getSslContext().ifPresent(context -> {
            JdkSslContext jdkSslContext = new JdkSslContext(context, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}), ClientAuth.OPTIONAL, null, false);
            nettyChannelBuilder.sslContext((SslContext)jdkSslContext).useTransportSecurity();
        });
        return managedChannelBuilder.proxyDetector(this.proxyTransportFactory::createProxyDetector);
    }
}

