/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.cloud.http.HttpTransportOptions;
import com.google.inject.Inject;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ProxiedSocketAddress;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientTelemetry;
import io.trino.plugin.base.ssl.SslUtils;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryProxyConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;

public interface ProxyTransportFactory {
    public HttpTransportOptions getTransportOptions();

    public Optional<SSLContext> getSslContext();

    public ProxiedSocketAddress createProxyDetector(SocketAddress var1);

    public static class DefaultProxyTransportFactory
    implements ProxyTransportFactory {
        private final HttpTransportOptions transportOptions;
        private final Optional<SSLContext> sslContext;
        private final URI proxyUri;
        private final Optional<String> proxyUsername;
        private final Optional<String> proxyPassword;

        @Inject
        public DefaultProxyTransportFactory(OpenTelemetry openTelemetry, BigQueryProxyConfig proxyConfig) {
            Objects.requireNonNull(proxyConfig, "proxyConfig is null");
            this.proxyUri = proxyConfig.getUri();
            this.proxyUsername = proxyConfig.getUsername();
            this.proxyPassword = proxyConfig.getPassword();
            this.sslContext = DefaultProxyTransportFactory.buildSslContext(proxyConfig.getKeystorePath(), proxyConfig.getKeystorePassword(), proxyConfig.getTruststorePath(), proxyConfig.getTruststorePassword());
            this.transportOptions = DefaultProxyTransportFactory.buildTransportOptions(openTelemetry, this.sslContext, this.proxyUri, this.proxyUsername, this.proxyPassword);
        }

        @Override
        public HttpTransportOptions getTransportOptions() {
            return this.transportOptions;
        }

        @Override
        public Optional<SSLContext> getSslContext() {
            return this.sslContext;
        }

        @Override
        public ProxiedSocketAddress createProxyDetector(SocketAddress socketAddress) {
            HttpConnectProxiedSocketAddress.Builder builder = HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress((SocketAddress)new InetSocketAddress(this.proxyUri.getHost(), this.proxyUri.getPort())).setTargetAddress((InetSocketAddress)socketAddress);
            this.proxyUsername.ifPresent(arg_0 -> ((HttpConnectProxiedSocketAddress.Builder)builder).setUsername(arg_0));
            this.proxyPassword.ifPresent(arg_0 -> ((HttpConnectProxiedSocketAddress.Builder)builder).setPassword(arg_0));
            return builder.build();
        }

        private static HttpTransportOptions buildTransportOptions(OpenTelemetry openTelemetry, Optional<SSLContext> sslContext, URI proxyUri, Optional<String> proxyUser, Optional<String> proxyPassword) {
            HttpHost proxyHost = new HttpHost(proxyUri.getHost(), proxyUri.getPort());
            DefaultProxyRoutePlanner httpRoutePlanner = new DefaultProxyRoutePlanner(proxyHost);
            HttpClientBuilder httpClientBuilder = ApacheHttpClientTelemetry.create((OpenTelemetry)openTelemetry).newHttpClientBuilder().setRoutePlanner((HttpRoutePlanner)httpRoutePlanner);
            if (sslContext.isPresent()) {
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext.get());
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            }
            if (proxyUser.isPresent()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUser.get(), proxyPassword.orElse("")));
                httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            CloseableHttpClient client = httpClientBuilder.build();
            return HttpTransportOptions.newBuilder().setHttpTransportFactory(() -> DefaultProxyTransportFactory.lambda$buildTransportOptions$0((HttpClient)client)).build();
        }

        private static Optional<SSLContext> buildSslContext(Optional<File> keyStorePath, Optional<String> keyStorePassword, Optional<File> trustStorePath, Optional<String> trustStorePassword) {
            if (keyStorePath.isEmpty() && trustStorePath.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of(SslUtils.createSSLContext(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_PROXY_SSL_INITIALIZATION_FAILED, (Throwable)e);
            }
        }

        private static /* synthetic */ HttpTransport lambda$buildTransportOptions$0(HttpClient client) {
            return new ApacheHttpTransport(client);
        }
    }
}

