/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.HttpHeaderSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientRequestResendCount;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;

final class TracingProtocolExec
implements ClientExecChain {
    private static final String REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID = TracingProtocolExec.class.getName() + ".context";
    private final Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter;
    private final ContextPropagators propagators;
    private final ClientExecChain exec;

    TracingProtocolExec(Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter, ContextPropagators propagators, ClientExecChain exec) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
        this.exec = exec;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext httpContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        ApacheHttpClientRequest instrumenterRequest;
        Context parentContext = (Context)httpContext.getAttribute(REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID, Context.class);
        if (parentContext == null) {
            parentContext = HttpClientRequestResendCount.initialize((Context)Context.current());
            httpContext.setAttribute(REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID, (Object)parentContext);
        }
        HttpHost host = null;
        if (route.getTargetHost() != null) {
            host = route.getTargetHost();
        } else if (httpContext.getTargetHost() != null) {
            host = httpContext.getTargetHost();
        }
        if (host != null && (host.getSchemeName().equals("https") && host.getPort() == 443 || host.getSchemeName().equals("http") && host.getPort() == 80)) {
            host = new HttpHost(host.getHostName(), -1, host.getSchemeName());
        }
        if (!this.instrumenter.shouldStart(parentContext, (Object)(instrumenterRequest = new ApacheHttpClientRequest(host, (HttpRequest)request)))) {
            return this.exec.execute(route, request, httpContext, httpExecutionAware);
        }
        Context context = this.instrumenter.start(parentContext, (Object)instrumenterRequest);
        this.propagators.getTextMapPropagator().inject(context, (Object)request, (TextMapSetter)HttpHeaderSetter.INSTANCE);
        return this.execute(route, request, instrumenterRequest, httpContext, httpExecutionAware, context);
    }

    private CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, ApacheHttpClientRequest instrumenterRequest, HttpClientContext httpContext, HttpExecutionAware httpExecutionAware, Context context) throws IOException, HttpException {
        CloseableHttpResponse response;
        try (Scope ignored = context.makeCurrent();){
            response = this.exec.execute(route, request, httpContext, httpExecutionAware);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)instrumenterRequest, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)instrumenterRequest, (Object)response, null);
        return response;
    }
}

