/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.trino.plugin.blackhole.BlackHoleInsertTableHandle;
import io.trino.plugin.blackhole.BlackHoleMergeSink;
import io.trino.plugin.blackhole.BlackHoleOutputTableHandle;
import io.trino.plugin.blackhole.BlackHolePageSink;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class BlackHolePageSinkProvider
implements ConnectorPageSinkProvider {
    private final ListeningScheduledExecutorService executorService;

    public BlackHolePageSinkProvider(ListeningScheduledExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        BlackHoleOutputTableHandle handle = (BlackHoleOutputTableHandle)outputTableHandle;
        return new BlackHolePageSink(this.executorService, handle.pageProcessingDelay());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        BlackHoleInsertTableHandle handle = (BlackHoleInsertTableHandle)insertTableHandle;
        return new BlackHolePageSink(this.executorService, handle.pageProcessingDelay());
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        return new BlackHoleMergeSink();
    }
}

