/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.Duration;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

class BlackHolePageSource
implements ConnectorPageSource {
    private final Page page;
    private int pagesLeft;
    private final ListeningScheduledExecutorService executorService;
    private final long pageProcessingDelayInMillis;
    private long completedBytes;
    private final long memoryUsageBytes;
    private boolean closed;
    private CompletableFuture<Page> currentPage;

    BlackHolePageSource(Page page, int count, ListeningScheduledExecutorService executorService, Duration pageProcessingDelay) {
        this.page = Objects.requireNonNull(page, "page is null");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count is negative");
        this.pagesLeft = count;
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.pageProcessingDelayInMillis = pageProcessingDelay.toMillis();
        this.memoryUsageBytes = page.getSizeInBytes();
    }

    public SourcePage getNextSourcePage() {
        if (this.isFinished()) {
            return null;
        }
        if (this.currentPage != null) {
            Page page = (Page)MoreFutures.getFutureValue(this.currentPage);
            this.currentPage = null;
            return SourcePage.create((Page)page);
        }
        --this.pagesLeft;
        this.completedBytes += this.page.getSizeInBytes();
        if (this.pageProcessingDelayInMillis == 0L) {
            return SourcePage.create((Page)this.page);
        }
        this.currentPage = MoreFutures.toCompletableFuture((ListenableFuture)this.executorService.schedule(() -> this.page, this.pageProcessingDelayInMillis, TimeUnit.MILLISECONDS));
        return null;
    }

    public CompletableFuture<?> isBlocked() {
        if (this.currentPage != null) {
            return this.currentPage;
        }
        return NOT_BLOCKED;
    }

    public boolean isFinished() {
        return this.closed || this.pagesLeft == 0 && this.currentPage == null;
    }

    public void close() {
        this.closed = true;
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public long getMemoryUsage() {
        return this.memoryUsageBytes;
    }
}

