/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.blackhole.BlackHoleColumnHandle;
import io.trino.plugin.blackhole.BlackHolePageSource;
import io.trino.plugin.blackhole.BlackHoleTableHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class BlackHolePageSourceProvider
implements ConnectorPageSourceProvider {
    private final ListeningScheduledExecutorService executorService;

    public BlackHolePageSourceProvider(ListeningScheduledExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            builder.add((Object)((BlackHoleColumnHandle)column).columnType());
        }
        ImmutableList types = builder.build();
        Page page = this.generateZeroPage((List<Type>)types, table.rowsPerPage(), table.fieldsLength());
        return new BlackHolePageSource(page, table.pagesPerSplit(), this.executorService, table.pageProcessingDelay());
    }

    private Page generateZeroPage(List<Type> types, int rowsCount, int fieldLength) {
        byte[] constantBytes = new byte[fieldLength];
        Arrays.fill(constantBytes, (byte)42);
        Slice constantSlice = Slices.wrappedBuffer((byte[])constantBytes);
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.createZeroBlock(types.get(i), rowsCount, constantSlice);
        }
        return new Page(rowsCount, blocks);
    }

    private Block createZeroBlock(Type type, int rowsCount, Slice constantSlice) {
        BlockBuilder builder;
        VarcharType varcharType;
        Preconditions.checkArgument((boolean)BlackHolePageSourceProvider.isSupportedType(type), (String)"Unsupported type [%s]", (Object)type);
        Slice slice = type instanceof VarcharType && !(varcharType = (VarcharType)type).isUnbounded() ? constantSlice.slice(0, Math.min(varcharType.getBoundedLength(), constantSlice.length())) : constantSlice;
        if (type instanceof FixedWidthType) {
            FixedWidthType fixedWidthType = (FixedWidthType)type;
            builder = fixedWidthType.createFixedSizeBlockBuilder(rowsCount);
        } else {
            builder = type.createBlockBuilder(null, rowsCount, slice.length());
        }
        for (int i = 0; i < rowsCount; ++i) {
            DecimalType decimalType;
            Class javaType = type.getJavaType();
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(builder, false);
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(builder, 0L);
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(builder, 0.0);
                continue;
            }
            if (javaType == Slice.class) {
                Objects.requireNonNull(slice, "slice is null");
                type.writeSlice(builder, slice, 0, slice.length());
                continue;
            }
            if (type instanceof DecimalType && !(decimalType = (DecimalType)type).isShort()) {
                type.writeObject(builder, (Object)Int128.ZERO);
                continue;
            }
            throw new UnsupportedOperationException("Unknown javaType: " + javaType.getName());
        }
        return builder.build();
    }

    private static boolean isSupportedType(Type type) {
        return BlackHolePageSourceProvider.isNumericType(type) || type instanceof BooleanType || type instanceof DateType || type instanceof TimestampType || type instanceof VarcharType || type instanceof VarbinaryType;
    }

    public static boolean isNumericType(Type type) {
        return type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof RealType || type instanceof DoubleType || type instanceof DecimalType;
    }
}

