/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.cache.Cache;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.jmh.Benchmarks;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=1)
@Warmup(iterations=5, time=700, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=700, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkEvictableCache {
    @Benchmark
    public void cacheBenchmark(CacheBenchmarkState state) throws InterruptedException, ExecutionException {
        Cache cache = EvictableCacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(60L)).maximumSize(1000L).build();
        try (ExecutorService executor = Executors.newFixedThreadPool(state.competingThreadsCount);){
            for (int iteration = 0; iteration < state.iterations; ++iteration) {
                CountDownLatch startLatch = new CountDownLatch(state.competingThreadsCount);
                CountDownLatch endLatch = new CountDownLatch(state.competingThreadsCount);
                for (int threadIndex = 0; threadIndex < state.competingThreadsCount; ++threadIndex) {
                    executor.submit(() -> {
                        try {
                            startLatch.countDown();
                            startLatch.await();
                            cache.get((Object)"key", state.expensiveCacheLoaderSupplier.apply(state.cacheValueLoadTimeMillis));
                            endLatch.countDown();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(e);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                endLatch.await();
                cache.get((Object)"key", state.expensiveCacheLoaderSupplier.apply(state.cacheValueLoadTimeMillis));
            }
        }
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkEvictableCache.class).run();
    }

    @State(value=Scope.Benchmark)
    public static class CacheBenchmarkState {
        public final Function<Integer, Callable<String>> expensiveCacheLoaderSupplier = cacheValueLoadTime -> () -> {
            if (cacheValueLoadTime > 0) {
                Thread.sleep(cacheValueLoadTime.intValue());
            }
            return "key_nano:" + System.nanoTime();
        };
        @Param(value={"2", "5", "15", "50"})
        public int competingThreadsCount;
        @Param(value={"1", "2", "5"})
        public int iterations;
        @Param(value={"0", "500", "2000"})
        public int cacheValueLoadTimeMillis;
    }
}

