/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class CacheStatsAssertions {
    private final Supplier<CacheStats> stats;
    private long loads;
    private long hits;
    private long misses;

    public static CacheStatsAssertions assertCacheStats(Cache<?, ?> cache) {
        Objects.requireNonNull(cache, "cache is null");
        return CacheStatsAssertions.assertCacheStats(() -> cache.stats());
    }

    public static CacheStatsAssertions assertCacheStats(Supplier<CacheStats> statsSupplier) {
        return new CacheStatsAssertions(statsSupplier);
    }

    private CacheStatsAssertions(Supplier<CacheStats> stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public CacheStatsAssertions loads(long value) {
        this.loads = value;
        return this;
    }

    public CacheStatsAssertions hits(long value) {
        this.hits = value;
        return this;
    }

    public CacheStatsAssertions misses(long value) {
        this.misses = value;
        return this;
    }

    public void afterRunning(Runnable runnable) {
        try {
            this.calling(() -> {
                runnable.run();
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T calling(Callable<T> callable) throws Exception {
        CacheStats beforeStats = this.stats.get();
        T value = callable.call();
        CacheStats afterStats = this.stats.get();
        long loadDelta = afterStats.loadCount() - beforeStats.loadCount();
        long missesDelta = afterStats.missCount() - beforeStats.missCount();
        long hitsDelta = afterStats.hitCount() - beforeStats.hitCount();
        ((AbstractLongAssert)Assertions.assertThat((long)loadDelta).as("loads (delta)", new Object[0])).isEqualTo(this.loads);
        ((AbstractLongAssert)Assertions.assertThat((long)hitsDelta).as("hits (delta)", new Object[0])).isEqualTo(this.hits);
        ((AbstractLongAssert)Assertions.assertThat((long)missesDelta).as("misses (delta)", new Object[0])).isEqualTo(this.misses);
        return value;
    }
}

