/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class MoreFutures {
    private MoreFutures() {
    }

    public static <V> V getFutureValue(Future<V> future) {
        return MoreFutures.getFutureValue(future, RuntimeException.class);
    }

    public static <V, E extends Exception> V getFutureValue(Future<V> future, Class<E> exceptionType) throws E {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(exceptionType, "exceptionType is null");
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.throwIfInstanceOf((Throwable)cause, exceptionType);
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(cause);
        }
    }
}

