/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import io.trino.cache.EmptyCache;
import io.trino.testing.assertions.Assert;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestEmptyCache {
    private static final int TEST_TIMEOUT_SECONDS = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testLoadFailure() throws Exception {
        EmptyCache cache = new EmptyCache(CacheLoader.from(() -> {
            throw new UnsupportedOperationException();
        }), false);
        int key = 10;
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Exchanger exchanger = new Exchanger();
            CountDownLatch secondUnblocked = new CountDownLatch(1);
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
            for (int i = 0; i < 2; ++i) {
                boolean first = i == 0;
                futures.add(executor.submit(() -> TestEmptyCache.lambda$testLoadFailure$1(first, exchanger, secondUnblocked, (Cache)cache, key)));
            }
            ArrayList<String> results = new ArrayList<String>();
            for (Future future : futures) {
                try {
                    results.add((String)future.get());
                }
                catch (ExecutionException e) {
                    results.add(e.getCause().toString());
                }
            }
            Assertions.assertThat(results).containsExactlyInAnyOrder((Object[])new String[]{"success", "com.google.common.util.concurrent.UncheckedExecutionException: java.lang.RuntimeException: first attempt is poised to fail"});
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    private static /* synthetic */ String lambda$testLoadFailure$1(boolean first, Exchanger exchanger, CountDownLatch secondUnblocked, Cache cache, int key) throws Exception {
        if (!first) {
            exchanger.exchange(Thread.currentThread(), 10L, TimeUnit.SECONDS);
            secondUnblocked.countDown();
        }
        return (String)cache.get((Object)key, () -> {
            if (first) {
                Thread secondThread = exchanger.exchange(null, 10L, TimeUnit.SECONDS);
                Assertions.assertThat((boolean)secondUnblocked.await(10L, TimeUnit.SECONDS)).isTrue();
                Assert.assertEventually(() -> Assertions.assertThat((Comparable)((Object)secondThread.getState())).isNotEqualTo((Object)Thread.State.RUNNABLE));
                throw new RuntimeException("first attempt is poised to fail");
            }
            return "success";
        });
    }
}

