/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.TestingTicker;
import io.trino.cache.CacheStatsAssertions;
import io.trino.cache.EvictableCache;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.cache.Invalidation;
import io.trino.cache.MoreFutures;
import io.trino.testing.assertions.Assert;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicIntegerAssert;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestEvictableCache {
    private static final int TEST_TIMEOUT_SECONDS = 10;

    @Test
    @Timeout(value=10L)
    public void testLoad() throws Exception {
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build();
        Assertions.assertThat((String)((String)cache.get((Object)42, () -> "abc"))).isEqualTo("abc");
    }

    @Test
    @Timeout(value=10L)
    public void testEvictBySize() throws Exception {
        int maximumSize = 10;
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize((long)maximumSize).build();
        for (int i = 0; i < 10000; ++i) {
            int value = i * 10;
            Assertions.assertThat((Object)cache.get((Object)i, () -> value)).isEqualTo((Object)value);
        }
        cache.cleanUp();
        Assertions.assertThat((long)cache.size()).isEqualTo((long)maximumSize);
        Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).isEqualTo(maximumSize);
        int lastKey = 9999;
        Assertions.assertThat((Object)cache.get((Object)lastKey, () -> {
            throw new UnsupportedOperationException();
        })).isEqualTo((Object)(lastKey * 10));
    }

    @Test
    @Timeout(value=10L)
    public void testEvictByWeight() throws Exception {
        Cache cache = EvictableCacheBuilder.newBuilder().maximumWeight(20L).weigher((key, value) -> value.length()).build();
        for (int i2 = 0; i2 < 10; ++i2) {
            String value2 = "a".repeat(i2);
            Assertions.assertThat((Object)cache.get((Object)i2, () -> value2)).isEqualTo((Object)value2);
        }
        cache.cleanUp();
        int cacheSize = Math.toIntExact(cache.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(cacheSize);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).hasSize(cacheSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cache.asMap().keySet().stream().mapToInt(i -> i).sum()).as("key sum", new Object[0])).isLessThanOrEqualTo(20);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).hasSize(cacheSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cache.asMap().values().stream().mapToInt(String::length).sum()).as("values length sum", new Object[0])).isLessThanOrEqualTo(20);
        int lastKey = 9;
        Assertions.assertThat((String)((String)cache.get((Object)lastKey, () -> {
            throw new UnsupportedOperationException();
        }))).isEqualTo("a".repeat(lastKey));
    }

    @Test
    @Timeout(value=10L)
    public void testEvictByTime() throws Exception {
        TestingTicker ticker = new TestingTicker();
        int ttl = 100;
        Cache cache = EvictableCacheBuilder.newBuilder().ticker((Ticker)ticker).expireAfterWrite((long)ttl, TimeUnit.MILLISECONDS).build();
        Assertions.assertThat((String)((String)cache.get((Object)1, () -> "1 ala ma kota"))).isEqualTo("1 ala ma kota");
        ticker.increment((long)ttl, TimeUnit.MILLISECONDS);
        Assertions.assertThat((String)((String)cache.get((Object)2, () -> "2 ala ma kota"))).isEqualTo("2 ala ma kota");
        cache.cleanUp();
        int cacheSize = Math.toIntExact(cache.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)cacheSize).as("cacheSize", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(cacheSize);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).hasSize(cacheSize);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).hasSize(cacheSize);
    }

    @Test
    @Timeout(value=10L)
    public void testPreserveValueLoadedAfterTimeExpiration() throws Exception {
        TestingTicker ticker = new TestingTicker();
        int ttl = 100;
        Cache cache = EvictableCacheBuilder.newBuilder().ticker((Ticker)ticker).expireAfterWrite((long)ttl, TimeUnit.MILLISECONDS).build();
        int key = 11;
        Assertions.assertThat((String)((String)cache.get((Object)key, () -> "11 ala ma kota"))).isEqualTo("11 ala ma kota");
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        Assertions.assertThat((String)((String)cache.get((Object)key, () -> "something else"))).isEqualTo("11 ala ma kota");
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        ticker.increment((long)ttl, TimeUnit.MILLISECONDS);
        Assertions.assertThat((String)((String)cache.get((Object)key, () -> "new value"))).isEqualTo("new value");
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        Assertions.assertThat((String)((String)cache.get((Object)key, () -> "something yet different"))).isEqualTo("new value");
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        ((AbstractLongAssert)Assertions.assertThat((long)cache.size()).as("cacheSize", new Object[0])).isEqualTo(1L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).hasSize(1);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).hasSize(1);
    }

    @Test
    @Timeout(value=10L)
    public void testReplace() throws Exception {
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10L).build();
        int key = 10;
        int initialValue = 20;
        int replacedValue = 21;
        cache.get((Object)key, () -> initialValue);
        Assertions.assertThat((boolean)cache.asMap().replace(key, initialValue, replacedValue)).isTrue();
        Assertions.assertThat((Object)cache.getIfPresent((Object)key)).isEqualTo((Object)replacedValue);
        Assertions.assertThat((boolean)cache.asMap().replace(key, initialValue, replacedValue)).isFalse();
        Assertions.assertThat((Object)cache.getIfPresent((Object)key)).isEqualTo((Object)replacedValue);
        Assertions.assertThat((boolean)cache.asMap().replace(100000, replacedValue, 22)).isFalse();
        Assertions.assertThat(cache.asMap().keySet()).isEqualTo((Object)ImmutableSet.of((Object)key));
        Assertions.assertThat((Object)cache.getIfPresent((Object)key)).isEqualTo((Object)replacedValue);
        int anotherKey = 13;
        int anotherInitialValue = 14;
        cache.get((Object)anotherKey, () -> anotherInitialValue);
        cache.invalidate((Object)anotherKey);
        Assertions.assertThat((boolean)cache.asMap().replace(anotherKey, anotherInitialValue, 15)).isFalse();
        Assertions.assertThat(cache.asMap().keySet()).isEqualTo((Object)ImmutableSet.of((Object)key));
    }

    @Test
    @Timeout(value=10L)
    public void testDisabledCache() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EvictableCacheBuilder.newBuilder().maximumSize(0L).build()).isInstanceOf(IllegalStateException.class)).hasMessage("Even when cache is disabled, the loads are synchronized and both load results and failures are shared between threads. This is rarely desired, thus builder caller is expected to either opt-in into this behavior with shareResultsAndFailuresEvenIfDisabled(), or choose not to share results (and failures) between concurrent invocations with shareNothingWhenDisabled().");
        this.testDisabledCache((Cache<Integer, Integer>)EvictableCacheBuilder.newBuilder().maximumSize(0L).shareNothingWhenDisabled().build());
        this.testDisabledCache((Cache<Integer, Integer>)EvictableCacheBuilder.newBuilder().maximumSize(0L).shareResultsAndFailuresEvenIfDisabled().build());
    }

    private void testDisabledCache(Cache<Integer, Integer> cache) throws Exception {
        for (int i = 0; i < 10; ++i) {
            int value = i * 10;
            Assertions.assertThat((Object)cache.get((Object)i, () -> value)).isEqualTo((Object)value);
        }
        cache.cleanUp();
        Assertions.assertThat((long)cache.size()).isEqualTo(0L);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).isEmpty();
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).isEmpty();
    }

    @Test
    @Timeout(value=10L)
    public void testLoadStats() throws Exception {
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).recordStats().build();
        Assertions.assertThat((Object)cache.stats()).isEqualTo((Object)new CacheStats(0L, 0L, 0L, 0L, 0L, 0L));
        String value = CacheStatsAssertions.assertCacheStats(cache).misses(1L).loads(1L).calling(() -> (String)cache.get((Object)42, () -> "abc"));
        Assertions.assertThat((String)value).isEqualTo("abc");
        value = CacheStatsAssertions.assertCacheStats(cache).hits(1L).calling(() -> (String)cache.get((Object)42, () -> "xyz"));
        Assertions.assertThat((String)value).isEqualTo("abc");
        value = CacheStatsAssertions.assertCacheStats(cache).hits(1L).calling(() -> (String)cache.get((Object)TestEvictableCache.newInteger(42), () -> "xyz"));
        Assertions.assertThat((String)value).isEqualTo("abc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testLoadFailure() throws Exception {
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(0L).expireAfterWrite(0L, TimeUnit.DAYS).shareResultsAndFailuresEvenIfDisabled().build();
        int key = 10;
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Exchanger exchanger = new Exchanger();
            CountDownLatch secondUnblocked = new CountDownLatch(1);
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
            for (int i = 0; i < 2; ++i) {
                boolean first = i == 0;
                futures.add(executor.submit(() -> {
                    if (!first) {
                        exchanger.exchange(Thread.currentThread(), 10L, TimeUnit.SECONDS);
                        secondUnblocked.countDown();
                    }
                    return (String)cache.get((Object)key, () -> {
                        if (first) {
                            Thread secondThread = exchanger.exchange(null, 10L, TimeUnit.SECONDS);
                            Assertions.assertThat((boolean)secondUnblocked.await(10L, TimeUnit.SECONDS)).isTrue();
                            Assert.assertEventually(() -> Assertions.assertThat((Comparable)((Object)secondThread.getState())).isNotEqualTo((Object)Thread.State.RUNNABLE));
                            throw new RuntimeException("first attempt is poised to fail");
                        }
                        return "success";
                    });
                }));
            }
            ArrayList<String> results = new ArrayList<String>();
            for (Future future : futures) {
                try {
                    results.add((String)future.get());
                }
                catch (ExecutionException e) {
                    results.add(e.getCause().toString());
                }
            }
            Assertions.assertThat(results).containsExactly((Object[])new String[]{"com.google.common.util.concurrent.UncheckedExecutionException: java.lang.RuntimeException: first attempt is poised to fail", "com.google.common.util.concurrent.UncheckedExecutionException: java.lang.RuntimeException: first attempt is poised to fail"});
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @SuppressModernizer
    private static Integer newInteger(int value) {
        Integer integer = value;
        Integer newInteger = new Integer(value);
        Assertions.assertThat((Integer)integer).isNotSameAs((Object)newInteger);
        return newInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testConcurrentGetWithCallableShareLoad() throws Exception {
        AtomicInteger loads = new AtomicInteger();
        AtomicInteger concurrentInvocations = new AtomicInteger();
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build();
        int threads = 2;
        int invocationsPerThread = 100;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            CyclicBarrier barrier = new CyclicBarrier(threads);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(() -> {
                    for (int invocation = 0; invocation < invocationsPerThread; ++invocation) {
                        int key = invocation;
                        barrier.await(10L, TimeUnit.SECONDS);
                        int value = (Integer)cache.get((Object)key, () -> {
                            loads.incrementAndGet();
                            int invocations = concurrentInvocations.incrementAndGet();
                            Preconditions.checkState((invocations == 1 ? 1 : 0) != 0, (Object)"There should be no concurrent invocations, cache should do load sharing when get() invoked for same key");
                            Thread.sleep(1L);
                            concurrentInvocations.decrementAndGet();
                            return -key;
                        });
                        Assertions.assertThat((int)value).isEqualTo(-invocation);
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get(10L, TimeUnit.SECONDS);
            }
            ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)loads).as("loads", new Object[0])).hasValueBetween(invocationsPerThread, threads * invocationsPerThread - 1);
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testInvalidateOngoingLoad() throws Exception {
        for (Invalidation invalidation : Invalidation.values()) {
            Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build();
            Integer key = 42;
            CountDownLatch loadOngoing = new CountDownLatch(1);
            CountDownLatch invalidated = new CountDownLatch(1);
            CountDownLatch getReturned = new CountDownLatch(1);
            ExecutorService executor = Executors.newFixedThreadPool(2);
            try {
                Future<String> threadA = executor.submit(() -> {
                    String value = (String)cache.get((Object)key, () -> {
                        loadOngoing.countDown();
                        Assertions.assertThat((boolean)invalidated.await(10L, TimeUnit.SECONDS)).isTrue();
                        return "stale value";
                    });
                    getReturned.countDown();
                    return value;
                });
                Future<String> threadB = executor.submit(() -> {
                    Assertions.assertThat((boolean)loadOngoing.await(10L, TimeUnit.SECONDS)).isTrue();
                    switch (invalidation) {
                        case INVALIDATE_KEY: {
                            cache.invalidate((Object)key);
                            break;
                        }
                        case INVALIDATE_PREDEFINED_KEYS: {
                            cache.invalidateAll((Iterable)ImmutableList.of((Object)key));
                            break;
                        }
                        case INVALIDATE_SELECTED_KEYS: {
                            Set keys = (Set)cache.asMap().keySet().stream().filter(foundKey -> foundKey.intValue() == key.intValue()).collect(ImmutableSet.toImmutableSet());
                            cache.invalidateAll((Iterable)keys);
                            break;
                        }
                        case INVALIDATE_ALL: {
                            cache.invalidateAll();
                        }
                    }
                    invalidated.countDown();
                    Assertions.assertThat((boolean)getReturned.await(10L, TimeUnit.SECONDS)).isTrue();
                    return (String)cache.get((Object)key, () -> "fresh value");
                });
                Assertions.assertThat((String)threadA.get()).isEqualTo("stale value");
                Assertions.assertThat((String)threadB.get()).isEqualTo("fresh value");
            }
            catch (AssertionError e) {
                throw new AssertionError("Error for invalidation=%s: %s".formatted(new Object[]{invalidation, ((Throwable)((Object)e)).getMessage()}), (Throwable)((Object)e));
            }
            finally {
                executor.shutdownNow();
                Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
            }
        }
    }

    @Test
    @Timeout(value=10L)
    public void testInvalidateAndLoadConcurrently() throws Exception {
        for (Invalidation invalidation : Invalidation.values()) {
            int[] primes = new int[]{2, 3, 5, 7};
            AtomicLong remoteState = new AtomicLong(1L);
            Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build();
            Integer key = 42;
            int threads = 4;
            CyclicBarrier barrier = new CyclicBarrier(threads);
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            try {
                List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                    Assertions.assertThat((long)((Long)cache.get((Object)key, remoteState::get))).isEqualTo(1L);
                    int prime = primes[threadNumber];
                    barrier.await(10L, TimeUnit.SECONDS);
                    remoteState.updateAndGet(current -> current * (long)prime);
                    switch (invalidation) {
                        case INVALIDATE_KEY: {
                            cache.invalidate((Object)key);
                            break;
                        }
                        case INVALIDATE_PREDEFINED_KEYS: {
                            cache.invalidateAll((Iterable)ImmutableList.of((Object)key));
                            break;
                        }
                        case INVALIDATE_SELECTED_KEYS: {
                            Set keys = (Set)cache.asMap().keySet().stream().filter(foundKey -> foundKey.intValue() == key.intValue()).collect(ImmutableSet.toImmutableSet());
                            cache.invalidateAll((Iterable)keys);
                            break;
                        }
                        case INVALIDATE_ALL: {
                            cache.invalidateAll();
                        }
                    }
                    long current2 = (Long)cache.get((Object)key, remoteState::get);
                    if (current2 % (long)prime != 0L) {
                        throw new AssertionError((Object)String.format("The value read through cache (%s) in thread (%s) is not divisible by (%s)", current2, threadNumber, prime));
                    }
                    return null;
                })).collect(ImmutableList.toImmutableList());
                futures.forEach(MoreFutures::getFutureValue);
                Assertions.assertThat((long)remoteState.get()).isEqualTo(210L);
                Assertions.assertThat((long)((Long)cache.get((Object)key, remoteState::get))).isEqualTo(remoteState.get());
            }
            catch (AssertionError e) {
                throw new AssertionError("Error for invalidation=%s: %s".formatted(new Object[]{invalidation, ((Throwable)((Object)e)).getMessage()}), (Throwable)((Object)e));
            }
            finally {
                executor.shutdownNow();
                Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
            }
        }
    }

    @Test
    public void testPutOnEmptyCacheImplementation() {
        for (EvictableCacheBuilder.DisabledCacheImplementation disabledCacheImplementation : EvictableCacheBuilder.DisabledCacheImplementation.values()) {
            Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(0L).disabledCacheImplementation(disabledCacheImplementation).build();
            ConcurrentMap cacheMap = cache.asMap();
            int key = 0;
            int value = 1;
            Assertions.assertThat((Object)cacheMap.put(key, value)).isNull();
            Assertions.assertThat((Object)cacheMap.put(key, value)).isNull();
            Assertions.assertThat((Object)cacheMap.putIfAbsent(key, value)).isNull();
            Assertions.assertThat((Object)cacheMap.putIfAbsent(key, value)).isNull();
        }
    }

    @Test
    public void testPutOnNonEmptyCacheImplementation() {
        Cache cache = EvictableCacheBuilder.newBuilder().maximumSize(10L).build();
        ConcurrentMap cacheMap = cache.asMap();
        int key = 0;
        int value = 1;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cacheMap.put(key, value)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cacheMap.putIfAbsent(key, value)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The operation is not supported, as in inherently races with cache invalidation");
    }

    @RepeatedTest(value=1000)
    public void testParallelLoadingCacheEntries() {
        Cache cache = EvictableCacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(60L)).maximumSize(10L).build();
        try (ExecutorService executor = Executors.newFixedThreadPool(2);){
            Runnable cacheLoader = () -> {
                try {
                    String value = (String)cache.get((Object)"key", () -> "value");
                    Assertions.assertThat((String)value).isEqualTo("value");
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            };
            executor.submit(cacheLoader);
            executor.submit(cacheLoader);
        }
        Assertions.assertThat((String)((String)cache.getIfPresent((Object)"key"))).isNotNull();
    }
}

