/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.testing.TestingTicker;
import io.trino.cache.CacheStatsAssertions;
import io.trino.cache.EvictableCache;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.cache.Invalidation;
import io.trino.cache.MoreFutures;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicIntegerAssert;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestEvictableLoadingCache {
    private static final int TEST_TIMEOUT_SECONDS = 10;

    @Test
    @Timeout(value=10L)
    public void testLoad() throws Exception {
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).recordStats().build(CacheLoader.from(ignored -> "abc"));
        Assertions.assertThat((String)((String)cache.get((Object)42))).isEqualTo("abc");
    }

    @Test
    @Timeout(value=10L)
    public void testEvictBySize() throws Exception {
        int maximumSize = 10;
        AtomicInteger loads = new AtomicInteger();
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize((long)maximumSize).build(CacheLoader.from(key -> {
            loads.incrementAndGet();
            return "abc" + key;
        }));
        for (int i = 0; i < 10000; ++i) {
            Assertions.assertThat((Object)cache.get((Object)i)).isEqualTo((Object)("abc" + i));
        }
        cache.cleanUp();
        Assertions.assertThat((long)cache.size()).isEqualTo((long)maximumSize);
        Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).isEqualTo(maximumSize);
        Assertions.assertThat((int)loads.get()).isEqualTo(10000);
        int lastKey = 9999;
        Assertions.assertThat((Object)cache.get((Object)lastKey)).isEqualTo((Object)("abc" + lastKey));
        Assertions.assertThat((int)loads.get()).isEqualTo(10000);
    }

    @Test
    @Timeout(value=10L)
    public void testEvictByWeight() throws Exception {
        AtomicInteger loads = new AtomicInteger();
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumWeight(20L).weigher((key, value) -> value.length()).build(CacheLoader.from(key -> {
            loads.incrementAndGet();
            return "a".repeat((int)key);
        }));
        for (int i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((Object)cache.get((Object)i2)).isEqualTo((Object)"a".repeat(i2));
        }
        cache.cleanUp();
        int cacheSize = Math.toIntExact(cache.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(cacheSize);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).hasSize(cacheSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cache.asMap().keySet().stream().mapToInt(i -> i).sum()).as("key sum", new Object[0])).isLessThanOrEqualTo(20);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).hasSize(cacheSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cache.asMap().values().stream().mapToInt(String::length).sum()).as("values length sum", new Object[0])).isLessThanOrEqualTo(20);
        Assertions.assertThat((int)loads.get()).isEqualTo(10);
        int lastKey = 9;
        Assertions.assertThat((Object)cache.get((Object)lastKey)).isEqualTo((Object)"a".repeat(lastKey));
        Assertions.assertThat((int)loads.get()).isEqualTo(10);
    }

    @Test
    @Timeout(value=10L)
    public void testEvictByTime() {
        TestingTicker ticker = new TestingTicker();
        int ttl = 100;
        AtomicInteger loads = new AtomicInteger();
        LoadingCache cache = EvictableCacheBuilder.newBuilder().ticker((Ticker)ticker).expireAfterWrite((long)ttl, TimeUnit.MILLISECONDS).build(CacheLoader.from(k -> {
            loads.incrementAndGet();
            return k + " ala ma kota";
        }));
        Assertions.assertThat((String)((String)cache.getUnchecked((Object)1))).isEqualTo("1 ala ma kota");
        ticker.increment((long)ttl, TimeUnit.MILLISECONDS);
        Assertions.assertThat((String)((String)cache.getUnchecked((Object)2))).isEqualTo("2 ala ma kota");
        cache.cleanUp();
        int cacheSize = Math.toIntExact(cache.size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)cacheSize).as("cacheSize", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(cacheSize);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).hasSize(cacheSize);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).hasSize(cacheSize);
        Assertions.assertThat((int)loads.get()).isEqualTo(2);
    }

    @Test
    @Timeout(value=10L)
    public void testPreserveValueLoadedAfterTimeExpiration() {
        TestingTicker ticker = new TestingTicker();
        int ttl = 100;
        AtomicInteger loads = new AtomicInteger();
        LoadingCache cache = EvictableCacheBuilder.newBuilder().ticker((Ticker)ticker).expireAfterWrite((long)ttl, TimeUnit.MILLISECONDS).build(CacheLoader.from(k -> {
            loads.incrementAndGet();
            return k + " ala ma kota";
        }));
        int key = 11;
        Assertions.assertThat((String)((String)cache.getUnchecked((Object)key))).isEqualTo("11 ala ma kota");
        ((AbstractIntegerAssert)Assertions.assertThat((int)loads.get()).as("initial load count", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        Assertions.assertThat((String)((String)cache.getUnchecked((Object)key))).isEqualTo("11 ala ma kota");
        ((AbstractIntegerAssert)Assertions.assertThat((int)loads.get()).as("loads count should not change before value expires", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        ticker.increment((long)ttl, TimeUnit.MILLISECONDS);
        Assertions.assertThat((String)((String)cache.getUnchecked((Object)key))).isEqualTo("11 ala ma kota");
        ((AbstractIntegerAssert)Assertions.assertThat((int)loads.get()).as("loads count should reflect reloading of value after expiration", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        Assertions.assertThat((String)((String)cache.getUnchecked((Object)key))).isEqualTo("11 ala ma kota");
        ((AbstractIntegerAssert)Assertions.assertThat((int)loads.get()).as("loads count should not change before value expires again", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        ((AbstractLongAssert)Assertions.assertThat((long)cache.size()).as("cacheSize", new Object[0])).isEqualTo(1L);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((EvictableCache)cache).tokensCount()).as("tokensCount", new Object[0])).isEqualTo(1);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).hasSize(1);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).hasSize(1);
    }

    @Test
    @Timeout(value=10L)
    public void testDisabledCache() throws ExecutionException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EvictableCacheBuilder.newBuilder().maximumSize(0L).build(CacheLoader.from(key -> key * 10))).isInstanceOf(IllegalStateException.class)).hasMessage("Even when cache is disabled, the loads are synchronized and both load results and failures are shared between threads. This is rarely desired, thus builder caller is expected to either opt-in into this behavior with shareResultsAndFailuresEvenIfDisabled(), or choose not to share results (and failures) between concurrent invocations with shareNothingWhenDisabled().");
        this.testDisabledCache((LoadingCache<Integer, Integer>)EvictableCacheBuilder.newBuilder().maximumSize(0L).shareNothingWhenDisabled().build(CacheLoader.from(key -> key * 10)));
        this.testDisabledCache((LoadingCache<Integer, Integer>)EvictableCacheBuilder.newBuilder().maximumSize(0L).shareResultsAndFailuresEvenIfDisabled().build(CacheLoader.from(key -> key * 10)));
    }

    private void testDisabledCache(LoadingCache<Integer, Integer> cache) throws ExecutionException {
        for (int i = 0; i < 10; ++i) {
            Assertions.assertThat((Object)cache.get((Object)i)).isEqualTo((Object)(i * 10));
        }
        cache.cleanUp();
        Assertions.assertThat((long)cache.size()).isEqualTo(0L);
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().keySet()).as("keySet", new Object[0])).isEmpty();
        ((AbstractCollectionAssert)Assertions.assertThat(cache.asMap().values()).as("values", new Object[0])).isEmpty();
    }

    @Test
    @Timeout(value=10L)
    public void testLoadStats() throws Exception {
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).recordStats().build(CacheLoader.from(ignored -> "abc"));
        Assertions.assertThat((Object)cache.stats()).isEqualTo((Object)new CacheStats(0L, 0L, 0L, 0L, 0L, 0L));
        String value = CacheStatsAssertions.assertCacheStats(cache).misses(1L).loads(1L).calling(() -> (String)cache.get((Object)42));
        Assertions.assertThat((String)value).isEqualTo("abc");
        value = CacheStatsAssertions.assertCacheStats(cache).hits(1L).calling(() -> (String)cache.get((Object)42));
        Assertions.assertThat((String)value).isEqualTo("abc");
        value = CacheStatsAssertions.assertCacheStats(cache).hits(1L).calling(() -> (String)cache.get((Object)TestEvictableLoadingCache.newInteger(42)));
        Assertions.assertThat((String)value).isEqualTo("abc");
    }

    @SuppressModernizer
    private static Integer newInteger(int value) {
        Integer integer = value;
        Integer newInteger = new Integer(value);
        Assertions.assertThat((Integer)integer).isNotSameAs((Object)newInteger);
        return newInteger;
    }

    @Test
    @Timeout(value=10L)
    public void testGetAllMaintainsKeyIdentity() throws Exception {
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).recordStats().build(CacheLoader.from(String::length));
        String first = "abc";
        String second = new String(first);
        Assertions.assertThat((String)first).isNotSameAs((Object)second);
        Assertions.assertThat((int)((Integer)cache.get((Object)first))).isEqualTo(3);
        ImmutableMap values = cache.getAll((Iterable)ImmutableList.of((Object)second));
        Assertions.assertThat((Map)values).hasSize(1);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(values.entrySet());
        Assertions.assertThat((int)((Integer)entry.getValue())).isEqualTo(3);
        Assertions.assertThat((String)((String)entry.getKey())).isEqualTo(first);
        Assertions.assertThat((String)((String)entry.getKey())).isEqualTo(second);
        Assertions.assertThat((String)((String)entry.getKey())).isNotSameAs((Object)first);
        Assertions.assertThat((String)((String)entry.getKey())).isSameAs((Object)second);
    }

    @Test
    @Timeout(value=10L)
    public void testGetDoesNotMaintainKeyIdentityForLoader() throws Exception {
        AtomicInteger loadCounter = new AtomicInteger();
        int firstAdditionalField = 1;
        int secondAdditionalField = 123456789;
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build(CacheLoader.from(key -> {
            loadCounter.incrementAndGet();
            Assertions.assertThat((int)key.getAdditionalField()).isEqualTo(firstAdditionalField);
            return key.getValue();
        }));
        ClassWithPartialEquals keyA = new ClassWithPartialEquals(42, firstAdditionalField);
        ClassWithPartialEquals keyB = new ClassWithPartialEquals(42, secondAdditionalField);
        Assertions.assertThat((Object)keyA).isEqualTo((Object)keyB);
        Assertions.assertThat((int)keyA.getAdditionalField()).isNotEqualTo(keyB.getAdditionalField());
        Assertions.assertThat((int)((Integer)cache.get((Object)keyA, () -> 317))).isEqualTo(317);
        Assertions.assertThat((int)loadCounter.get()).isEqualTo(0);
        ((EvictableCache)cache).clearDataCacheOnly();
        Assertions.assertThat((int)((Integer)cache.get((Object)keyB))).isEqualTo(42);
        Assertions.assertThat((int)loadCounter.get()).isEqualTo(1);
    }

    @Test
    @Timeout(value=10L)
    public void testGetAllMaintainsKeyIdentityForBulkLoader() throws Exception {
        final AtomicInteger loadAllCounter = new AtomicInteger();
        final int expectedAdditionalField = 123456789;
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<ClassWithPartialEquals, Integer>(this){

            public Integer load(ClassWithPartialEquals key) {
                throw new UnsupportedOperationException();
            }

            public Map<ClassWithPartialEquals, Integer> loadAll(Iterable<? extends ClassWithPartialEquals> keys) {
                loadAllCounter.incrementAndGet();
                ClassWithPartialEquals key = (ClassWithPartialEquals)Iterables.getOnlyElement(keys);
                Assertions.assertThat((int)key.getAdditionalField()).isEqualTo(expectedAdditionalField);
                return ImmutableMap.of((Object)key, (Object)key.getValue());
            }
        });
        ClassWithPartialEquals keyA = new ClassWithPartialEquals(42, 1);
        ClassWithPartialEquals keyB = new ClassWithPartialEquals(42, expectedAdditionalField);
        Assertions.assertThat((Object)keyA).isEqualTo((Object)keyB);
        Assertions.assertThat((int)keyA.getAdditionalField()).isNotEqualTo(keyB.getAdditionalField());
        Assertions.assertThat((int)((Integer)cache.get((Object)keyA, () -> 317))).isEqualTo(317);
        Assertions.assertThat((int)loadAllCounter.get()).isEqualTo(0);
        ((EvictableCache)cache).clearDataCacheOnly();
        ImmutableMap map = cache.getAll((Iterable)ImmutableList.of((Object)keyB));
        Assertions.assertThat((Map)map).hasSize(1);
        Assertions.assertThat((Object)((ClassWithPartialEquals)Iterables.getOnlyElement(map.keySet()))).isSameAs((Object)keyB);
        Assertions.assertThat((int)((Integer)Iterables.getOnlyElement(map.values()))).isEqualTo(42);
        Assertions.assertThat((int)loadAllCounter.get()).isEqualTo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testConcurrentGetWithCallableShareLoad() throws Exception {
        AtomicInteger loads = new AtomicInteger();
        AtomicInteger concurrentInvocations = new AtomicInteger();
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build(CacheLoader.from(() -> {
            throw new UnsupportedOperationException();
        }));
        int threads = 2;
        int invocationsPerThread = 100;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            CyclicBarrier barrier = new CyclicBarrier(threads);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(() -> {
                    for (int invocation = 0; invocation < invocationsPerThread; ++invocation) {
                        int key = invocation;
                        barrier.await(10L, TimeUnit.SECONDS);
                        int value = (Integer)cache.get((Object)key, () -> {
                            loads.incrementAndGet();
                            int invocations = concurrentInvocations.incrementAndGet();
                            Preconditions.checkState((invocations == 1 ? 1 : 0) != 0, (Object)"There should be no concurrent invocations, cache should do load sharing when get() invoked for same key");
                            Thread.sleep(1L);
                            concurrentInvocations.decrementAndGet();
                            return -key;
                        });
                        Assertions.assertThat((int)value).isEqualTo(-invocation);
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get(10L, TimeUnit.SECONDS);
            }
            ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)loads).as("loads", new Object[0])).hasValueBetween(invocationsPerThread, threads * invocationsPerThread - 1);
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testConcurrentGetShareLoad() throws Exception {
        final AtomicInteger loads = new AtomicInteger();
        final AtomicInteger concurrentInvocations = new AtomicInteger();
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Integer, Integer>(this){

            public Integer load(Integer key) throws Exception {
                loads.incrementAndGet();
                int invocations = concurrentInvocations.incrementAndGet();
                Preconditions.checkState((invocations == 1 ? 1 : 0) != 0, (Object)"There should be no concurrent invocations, cache should do load sharing when get() invoked for same key");
                Thread.sleep(1L);
                concurrentInvocations.decrementAndGet();
                return -key.intValue();
            }
        });
        int threads = 2;
        int invocationsPerThread = 100;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            CyclicBarrier barrier = new CyclicBarrier(threads);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(() -> {
                    for (int invocation = 0; invocation < invocationsPerThread; ++invocation) {
                        barrier.await(10L, TimeUnit.SECONDS);
                        Assertions.assertThat((int)((Integer)cache.get((Object)invocation))).isEqualTo(-invocation);
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get(10L, TimeUnit.SECONDS);
            }
            ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)loads).as("loads", new Object[0])).hasValueBetween(invocationsPerThread, threads * invocationsPerThread - 1);
        }
        finally {
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testInvalidateOngoingLoad() throws Exception {
        for (Invalidation invalidation : Invalidation.values()) {
            final ConcurrentHashMap<Integer, String> remoteState = new ConcurrentHashMap<Integer, String>();
            Integer key = 42;
            remoteState.put(key, "stale value");
            final CountDownLatch loadOngoing = new CountDownLatch(1);
            final CountDownLatch invalidated = new CountDownLatch(1);
            CountDownLatch getReturned = new CountDownLatch(1);
            LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Integer, String>(this){

                public String load(Integer key) throws Exception {
                    String value = (String)remoteState.get(key);
                    loadOngoing.countDown();
                    Assertions.assertThat((boolean)invalidated.await(10L, TimeUnit.SECONDS)).isTrue();
                    return value;
                }
            });
            ExecutorService executor = Executors.newFixedThreadPool(2);
            try {
                Future<String> threadA = executor.submit(() -> {
                    String value = (String)cache.get((Object)key);
                    getReturned.countDown();
                    return value;
                });
                Future<String> threadB = executor.submit(() -> {
                    Assertions.assertThat((boolean)loadOngoing.await(10L, TimeUnit.SECONDS)).isTrue();
                    switch (invalidation) {
                        case INVALIDATE_KEY: {
                            cache.invalidate((Object)key);
                            break;
                        }
                        case INVALIDATE_PREDEFINED_KEYS: {
                            cache.invalidateAll((Iterable)ImmutableList.of((Object)key));
                            break;
                        }
                        case INVALIDATE_SELECTED_KEYS: {
                            Set keys = (Set)cache.asMap().keySet().stream().filter(foundKey -> foundKey.intValue() == key.intValue()).collect(ImmutableSet.toImmutableSet());
                            cache.invalidateAll((Iterable)keys);
                            break;
                        }
                        case INVALIDATE_ALL: {
                            cache.invalidateAll();
                        }
                    }
                    remoteState.put(key, "fresh value");
                    invalidated.countDown();
                    Assertions.assertThat((boolean)getReturned.await(10L, TimeUnit.SECONDS)).isTrue();
                    return (String)cache.get((Object)key);
                });
                Assertions.assertThat((String)threadA.get()).isEqualTo("stale value");
                Assertions.assertThat((String)threadB.get()).isEqualTo("fresh value");
            }
            catch (AssertionError e) {
                throw new AssertionError("Error for invalidation=%s: %s".formatted(new Object[]{invalidation, ((Throwable)((Object)e)).getMessage()}), (Throwable)((Object)e));
            }
            finally {
                executor.shutdownNow();
                Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
            }
        }
    }

    @RepeatedTest(value=10)
    @Timeout(value=10L)
    public void testInvalidateAndLoadConcurrently() throws Exception {
        for (Invalidation invalidation : Invalidation.values()) {
            int[] primes = new int[]{2, 3, 5, 7};
            Integer key = 42;
            ConcurrentHashMap<Integer, AtomicLong> remoteState = new ConcurrentHashMap<Integer, AtomicLong>();
            remoteState.put(key, new AtomicLong(1L));
            LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10000L).build(CacheLoader.from(i -> ((AtomicLong)remoteState.get(i)).get()));
            int threads = 4;
            CyclicBarrier barrier = new CyclicBarrier(threads);
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            try {
                List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                    Assertions.assertThat((long)((Long)cache.get((Object)key))).isEqualTo(1L);
                    int prime = primes[threadNumber];
                    barrier.await(10L, TimeUnit.SECONDS);
                    ((AtomicLong)remoteState.get(key)).updateAndGet(current -> current * (long)prime);
                    switch (invalidation) {
                        case INVALIDATE_KEY: {
                            cache.invalidate((Object)key);
                            break;
                        }
                        case INVALIDATE_PREDEFINED_KEYS: {
                            cache.invalidateAll((Iterable)ImmutableList.of((Object)key));
                            break;
                        }
                        case INVALIDATE_SELECTED_KEYS: {
                            Set keys = (Set)cache.asMap().keySet().stream().filter(foundKey -> foundKey.intValue() == key.intValue()).collect(ImmutableSet.toImmutableSet());
                            cache.invalidateAll((Iterable)keys);
                            break;
                        }
                        case INVALIDATE_ALL: {
                            cache.invalidateAll();
                        }
                    }
                    long current2 = (Long)cache.get((Object)key);
                    if (current2 % (long)prime != 0L) {
                        throw new AssertionError((Object)String.format("The value read through cache (%s) in thread (%s) is not divisible by (%s)", current2, threadNumber, prime));
                    }
                    return null;
                })).collect(ImmutableList.toImmutableList());
                futures.forEach(MoreFutures::getFutureValue);
                Assertions.assertThat(remoteState.keySet()).isEqualTo((Object)ImmutableSet.of((Object)key));
                Assertions.assertThat((long)((AtomicLong)remoteState.get(key)).get()).isEqualTo(210L);
                Assertions.assertThat((long)((Long)cache.get((Object)key))).isEqualTo(210L);
            }
            catch (AssertionError e) {
                throw new AssertionError("Error for invalidation=%s: %s".formatted(new Object[]{invalidation, ((Throwable)((Object)e)).getMessage()}), (Throwable)((Object)e));
            }
            finally {
                executor.shutdownNow();
                Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
            }
        }
    }

    @Test
    public void testPutOnEmptyCacheImplementation() {
        for (EvictableCacheBuilder.DisabledCacheImplementation disabledCacheImplementation : EvictableCacheBuilder.DisabledCacheImplementation.values()) {
            LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(0L).disabledCacheImplementation(disabledCacheImplementation).build(CacheLoader.from(key -> key));
            ConcurrentMap cacheMap = cache.asMap();
            int key2 = 0;
            int value = 1;
            Assertions.assertThat((Object)cacheMap.put(key2, value)).isNull();
            Assertions.assertThat((Object)cacheMap.put(key2, value)).isNull();
            Assertions.assertThat((Object)cacheMap.putIfAbsent(key2, value)).isNull();
            Assertions.assertThat((Object)cacheMap.putIfAbsent(key2, value)).isNull();
        }
    }

    @Test
    public void testPutOnNonEmptyCacheImplementation() {
        LoadingCache cache = EvictableCacheBuilder.newBuilder().maximumSize(10L).build(CacheLoader.from(key -> key));
        ConcurrentMap cacheMap = cache.asMap();
        int key2 = 0;
        int value = 1;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cacheMap.put(key2, value)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The operation is not supported, as in inherently races with cache invalidation. Use get(key, callable) instead.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cacheMap.putIfAbsent(key2, value)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The operation is not supported, as in inherently races with cache invalidation");
    }

    private static class ClassWithPartialEquals {
        private final int value;
        private final int additionalField;

        public ClassWithPartialEquals(int value, int additionalField) {
            this.value = value;
            this.additionalField = additionalField;
        }

        public int getValue() {
            return this.value;
        }

        public int getAdditionalField() {
            return this.additionalField;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass() && this.value == ((ClassWithPartialEquals)other).value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

