/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.NonKeyEvictableCache;
import io.trino.cache.NonKeyEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import java.util.concurrent.ConcurrentMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSafeCaches {
    @Test
    public void testNonEvictableCache() throws Exception {
        NonEvictableCache cache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder());
        TestSafeCaches.verifyKeyInvalidationIsImpossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyClearIsImpossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyLoadingIsPossible((Cache<Object, Object>)cache);
    }

    @Test
    public void testNonEvictableCacheWithWeakInvalidateAll() throws Exception {
        NonKeyEvictableCache cache = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)CacheBuilder.newBuilder());
        TestSafeCaches.verifyKeyInvalidationIsImpossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyClearIsPossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyLoadingIsPossible((Cache<Object, Object>)cache);
    }

    @Test
    public void testNonEvictableLoadingCache() throws Exception {
        NonEvictableLoadingCache cache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder(), (CacheLoader)CacheLoader.from(key -> key));
        TestSafeCaches.verifyKeyInvalidationIsImpossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyClearIsImpossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyLoadingIsPossible((Cache<Object, Object>)cache);
    }

    @Test
    public void testNonEvictableLoadingCacheWithWeakInvalidateAll() throws Exception {
        NonKeyEvictableLoadingCache cache = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)CacheBuilder.newBuilder(), (CacheLoader)CacheLoader.from(key -> key));
        TestSafeCaches.verifyKeyInvalidationIsImpossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyClearIsPossible((Cache<Object, Object>)cache);
        TestSafeCaches.verifyLoadingIsPossible((Cache<Object, Object>)cache);
    }

    private static void verifyLoadingIsPossible(Cache<Object, Object> cache) throws Exception {
        Object key = new Object();
        Object value = new Object();
        Assertions.assertThat((Object)cache.get(key, () -> value)).isSameAs(value);
    }

    private static void verifyKeyInvalidationIsImpossible(Cache<Object, Object> cache) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.invalidate(new Object())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("invalidate(key) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.invalidateAll((Iterable)ImmutableList.of())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("invalidateAll(keys) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation");
        Object object = new Object();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.asMap().remove(object)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("remove(key) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.asMap().remove(object, object)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("remove(key, value) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.asMap().replace(object, object)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("replace(key, value) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.asMap().replace(object, object, object)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("replace(key, oldValue, newValue) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
    }

    private static void verifyClearIsImpossible(Cache<Object, Object> cache) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cache.invalidateAll()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("invalidateAll does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCache if you need invalidation, or use SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll() if invalidateAll is not required for correctness");
        ConcurrentMap map = cache.asMap();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(map::clear).isInstanceOf(UnsupportedOperationException.class)).hasMessage("clear() does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
    }

    private static void verifyClearIsPossible(Cache<Object, Object> cache) throws Exception {
        Object key = new Object();
        Object firstValue = new Object();
        cache.get(key, () -> firstValue);
        Assertions.assertThat((Object)cache.getIfPresent(key)).isSameAs(firstValue);
        cache.invalidateAll();
        Assertions.assertThat((Object)cache.getIfPresent(key)).isNull();
        Object secondValue = new Object();
        cache.get(key, () -> secondValue);
        Assertions.assertThat((Object)cache.getIfPresent(key)).isSameAs(secondValue);
        cache.asMap().clear();
        Assertions.assertThat((Object)cache.getIfPresent(key)).isNull();
    }
}

