/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.helper;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistanceEvaluator;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.NodeDistanceEvaluatorHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.NodeFilterToDistanceEvaluatorAdapter;
import com.datastax.oss.driver.internal.core.util.Reflection;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultNodeDistanceEvaluatorHelper
implements NodeDistanceEvaluatorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNodeDistanceEvaluatorHelper.class);
    @NonNull
    protected final InternalDriverContext context;
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;

    public DefaultNodeDistanceEvaluatorHelper(@NonNull InternalDriverContext context, @NonNull DriverExecutionProfile profile, @NonNull String logPrefix) {
        this.context = context;
        this.profile = profile;
        this.logPrefix = logPrefix;
    }

    @Override
    @NonNull
    public NodeDistanceEvaluator createNodeDistanceEvaluator(@Nullable String localDc, @NonNull Map<UUID, Node> nodes) {
        NodeDistanceEvaluator nodeDistanceEvaluatorFromConfig = this.nodeDistanceEvaluatorFromConfig();
        return (node, dc) -> {
            NodeDistance distance = nodeDistanceEvaluatorFromConfig.evaluateDistance(node, dc);
            if (distance != null) {
                LOG.debug("[{}] Evaluator assigned distance {} to node {}", new Object[]{this.logPrefix, distance, node});
            } else {
                LOG.debug("[{}] Evaluator did not assign a distance to node {}", (Object)this.logPrefix, (Object)node);
            }
            return distance;
        };
    }

    @NonNull
    protected NodeDistanceEvaluator nodeDistanceEvaluatorFromConfig() {
        NodeDistanceEvaluator evaluator = this.context.getNodeDistanceEvaluator(this.profile.getName());
        if (evaluator != null) {
            LOG.debug("[{}] Node distance evaluator set programmatically", (Object)this.logPrefix);
        } else {
            evaluator = Reflection.buildFromConfig(this.context, this.profile.getName(), DefaultDriverOption.LOAD_BALANCING_DISTANCE_EVALUATOR_CLASS, NodeDistanceEvaluator.class, new String[0]).orElse(null);
            if (evaluator != null) {
                LOG.debug("[{}] Node distance evaluator set from configuration", (Object)this.logPrefix);
            } else {
                Predicate nodeFilterFromConfig = Reflection.buildFromConfig(this.context, this.profile.getName(), DefaultDriverOption.LOAD_BALANCING_FILTER_CLASS, Predicate.class, new String[0]).orElse(null);
                if (nodeFilterFromConfig != null) {
                    evaluator = new NodeFilterToDistanceEvaluatorAdapter(nodeFilterFromConfig);
                    LOG.debug("[{}] Node distance evaluator set from deprecated node filter configuration", (Object)this.logPrefix);
                }
            }
        }
        if (evaluator == null) {
            evaluator = PASS_THROUGH_DISTANCE_EVALUATOR;
        }
        return evaluator;
    }
}

