/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraNamedRelationHandle;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CassandraTable {
    private final CassandraNamedRelationHandle tableHandle;
    private final List<CassandraColumnHandle> columns;

    public CassandraTable(CassandraNamedRelationHandle tableHandle, List<CassandraColumnHandle> columns) {
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    public List<CassandraColumnHandle> getColumns() {
        return this.columns;
    }

    public CassandraNamedRelationHandle getTableHandle() {
        return this.tableHandle;
    }

    public List<CassandraColumnHandle> getPartitionKeyColumns() {
        return (List)this.columns.stream().filter(CassandraColumnHandle::isPartitionKey).collect(ImmutableList.toImmutableList());
    }

    public List<CassandraColumnHandle> getClusteringKeyColumns() {
        return (List)this.columns.stream().filter(CassandraColumnHandle::isClusteringKey).collect(ImmutableList.toImmutableList());
    }

    public String getTokenExpression() {
        StringBuilder sb = new StringBuilder();
        for (CassandraColumnHandle column : this.getPartitionKeyColumns()) {
            if (sb.length() == 0) {
                sb.append("token(");
            } else {
                sb.append(",");
            }
            sb.append(CassandraCqlUtils.validColumnName(column.getName()));
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.tableHandle.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CassandraTable)) {
            return false;
        }
        CassandraTable that = (CassandraTable)obj;
        return this.tableHandle.equals(that.tableHandle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).toString();
    }
}

