/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.DefaultWriteType;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import io.airlift.log.Logger;
import java.util.concurrent.ThreadLocalRandom;

public class BackoffRetryPolicy
implements RetryPolicy {
    private static final Logger log = Logger.get(BackoffRetryPolicy.class);
    private final String logPrefix;

    public BackoffRetryPolicy(DriverContext context, String profileName) {
        this.logPrefix = (context != null ? context.getSessionName() : null) + "|" + profileName;
    }

    public RetryDecision onReadTimeout(Request request, ConsistencyLevel consistencyLevel, int blockFor, int received, boolean dataPresent, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = retryCount == 0 && received >= blockFor && !dataPresent ? RetryDecision.RETRY_SAME : RetryDecision.RETHROW;
        if (decision == RetryDecision.RETRY_SAME) {
            log.debug("[%s] Retrying on read timeout on same host (consistency: %s, required responses: %s, received responses: %s, data retrieved: %s, retries: %s)", new Object[]{this.logPrefix, consistencyLevel, blockFor, received, false, retryCount});
        }
        return decision;
    }

    public RetryDecision onWriteTimeout(Request request, ConsistencyLevel consistencyLevel, WriteType writeType, int blockFor, int received, int retryCount) {
        RetryDecision decision;
        RetryDecision retryDecision = decision = retryCount == 0 && writeType == DefaultWriteType.BATCH_LOG ? RetryDecision.RETRY_SAME : RetryDecision.RETHROW;
        if (decision == RetryDecision.RETRY_SAME && log.isDebugEnabled()) {
            log.debug("[%s] Retrying on write timeout on same host (consistency: %s, write type: %s, required acknowledgments: %s, received acknowledgments: %s, retries: %s)", new Object[]{this.logPrefix, consistencyLevel, writeType, blockFor, received, retryCount});
        }
        return decision;
    }

    public RetryDecision onUnavailable(Request request, ConsistencyLevel consistencyLevel, int required, int alive, int retries) {
        if (retries >= 10) {
            return RetryDecision.RETHROW;
        }
        try {
            int jitter = ThreadLocalRandom.current().nextInt(100);
            int delay = 100 * (retries + 1) + jitter;
            Thread.sleep(delay);
            return RetryDecision.RETRY_SAME;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return RetryDecision.RETHROW;
        }
    }

    public RetryDecision onRequestAborted(Request request, Throwable error, int retryCount) {
        return RetryDecision.RETHROW;
    }

    public RetryDecision onErrorResponse(Request request, CoordinatorException error, int retryCount) {
        log.debug((Throwable)error, "[%s] Retrying on node error on next host (retries: %s)", new Object[]{this.logPrefix, retryCount});
        return RetryDecision.RETRY_NEXT;
    }

    public void close() {
    }
}

