/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import io.trino.plugin.cassandra.RetryPolicyType;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"cassandra.thrift-port", "cassandra.partitioner", "cassandra.thrift-connection-factory-class", "cassandra.transport-factory-options", "cassandra.no-host-available-retry-count", "cassandra.max-schema-refresh-threads", "cassandra.schema-cache-ttl", "cassandra.schema-refresh-interval", "cassandra.load-policy.use-white-list", "cassandra.load-policy.white-list.addresses", "cassandra.load-policy.use-token-aware", "cassandra.load-policy.token-aware.shuffle-replicas", "cassandra.load-policy.allowed-addresses"})
public class CassandraClientConfig {
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private int fetchSize = 5000;
    private List<String> contactPoints = ImmutableList.of();
    private int nativeProtocolPort = 9042;
    private int partitionSizeForBatchSelect = 100;
    private int splitSize = 1024;
    private int batchSize = 100;
    private Long splitsPerNode;
    private boolean allowDropTable;
    private Duration clientReadTimeout = new Duration(12000.0, TimeUnit.MILLISECONDS);
    private Duration clientConnectTimeout = new Duration(5000.0, TimeUnit.MILLISECONDS);
    private Integer clientSoLinger;
    private RetryPolicyType retryPolicy = RetryPolicyType.DEFAULT;
    private boolean useDCAware = true;
    private String dcAwareLocalDC;
    private int dcAwareUsedHostsPerRemoteDc;
    private boolean dcAwareAllowRemoteDCsForLocal;
    private Duration noHostAvailableRetryTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Optional<Integer> speculativeExecutionLimit = Optional.empty();
    private Duration speculativeExecutionDelay = new Duration(500.0, TimeUnit.MILLISECONDS);
    private ProtocolVersion protocolVersion;
    private boolean tlsEnabled;
    private CassandraAuthenticationType authenticationType = CassandraAuthenticationType.NONE;

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getContactPoints() {
        return this.contactPoints;
    }

    @Config(value="cassandra.contact-points")
    public CassandraClientConfig setContactPoints(List<String> contactPoints) {
        this.contactPoints = ImmutableList.copyOf(contactPoints);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getNativeProtocolPort() {
        return this.nativeProtocolPort;
    }

    @Config(value="cassandra.native-protocol-port")
    public CassandraClientConfig setNativeProtocolPort(int nativeProtocolPort) {
        this.nativeProtocolPort = nativeProtocolPort;
        return this;
    }

    @NotNull
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Config(value="cassandra.consistency-level")
    public CassandraClientConfig setConsistencyLevel(DefaultConsistencyLevel level) {
        this.consistencyLevel = level;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFetchSize() {
        return this.fetchSize;
    }

    @Config(value="cassandra.fetch-size")
    public CassandraClientConfig setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPartitionSizeForBatchSelect() {
        return this.partitionSizeForBatchSelect;
    }

    @Config(value="cassandra.partition-size-for-batch-select")
    public CassandraClientConfig setPartitionSizeForBatchSelect(int partitionSizeForBatchSelect) {
        this.partitionSizeForBatchSelect = partitionSizeForBatchSelect;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitSize() {
        return this.splitSize;
    }

    @Config(value="cassandra.split-size")
    public CassandraClientConfig setSplitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getBatchSize() {
        return this.batchSize;
    }

    @Config(value="cassandra.batch-size")
    public CassandraClientConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Optional<Long> getSplitsPerNode() {
        return Optional.ofNullable(this.splitsPerNode);
    }

    @Config(value="cassandra.splits-per-node")
    public CassandraClientConfig setSplitsPerNode(Long splitsPerNode) {
        this.splitsPerNode = splitsPerNode;
        return this;
    }

    public boolean getAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="cassandra.allow-drop-table")
    @ConfigDescription(value="Allow Cassandra connector to drop table")
    public CassandraClientConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public @MinDuration(value="1ms") @MaxDuration(value="1h") Duration getClientReadTimeout() {
        return this.clientReadTimeout;
    }

    @Config(value="cassandra.client.read-timeout")
    public CassandraClientConfig setClientReadTimeout(Duration clientReadTimeout) {
        this.clientReadTimeout = clientReadTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public @MinDuration(value="1ms") @MaxDuration(value="1h") Duration getClientConnectTimeout() {
        return this.clientConnectTimeout;
    }

    @Config(value="cassandra.client.connect-timeout")
    public CassandraClientConfig setClientConnectTimeout(Duration clientConnectTimeout) {
        this.clientConnectTimeout = clientConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) Integer getClientSoLinger() {
        return this.clientSoLinger;
    }

    @Config(value="cassandra.client.so-linger")
    public CassandraClientConfig setClientSoLinger(Integer clientSoLinger) {
        this.clientSoLinger = clientSoLinger;
        return this;
    }

    @NotNull
    public RetryPolicyType getRetryPolicy() {
        return this.retryPolicy;
    }

    @Config(value="cassandra.retry-policy")
    public CassandraClientConfig setRetryPolicy(RetryPolicyType retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public boolean isUseDCAware() {
        return this.useDCAware;
    }

    @Config(value="cassandra.load-policy.use-dc-aware")
    public CassandraClientConfig setUseDCAware(boolean useDCAware) {
        this.useDCAware = useDCAware;
        return this;
    }

    public String getDcAwareLocalDC() {
        return this.dcAwareLocalDC;
    }

    @Config(value="cassandra.load-policy.dc-aware.local-dc")
    public CassandraClientConfig setDcAwareLocalDC(String dcAwareLocalDC) {
        this.dcAwareLocalDC = dcAwareLocalDC;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) Integer getDcAwareUsedHostsPerRemoteDc() {
        return this.dcAwareUsedHostsPerRemoteDc;
    }

    @Config(value="cassandra.load-policy.dc-aware.used-hosts-per-remote-dc")
    public CassandraClientConfig setDcAwareUsedHostsPerRemoteDc(Integer dcAwareUsedHostsPerRemoteDc) {
        this.dcAwareUsedHostsPerRemoteDc = dcAwareUsedHostsPerRemoteDc;
        return this;
    }

    public boolean isDcAwareAllowRemoteDCsForLocal() {
        return this.dcAwareAllowRemoteDCsForLocal;
    }

    @Config(value="cassandra.load-policy.dc-aware.allow-remote-dc-for-local")
    public CassandraClientConfig setDcAwareAllowRemoteDCsForLocal(boolean dcAwareAllowRemoteDCsForLocal) {
        this.dcAwareAllowRemoteDCsForLocal = dcAwareAllowRemoteDCsForLocal;
        return this;
    }

    @NotNull
    public Duration getNoHostAvailableRetryTimeout() {
        return this.noHostAvailableRetryTimeout;
    }

    @Config(value="cassandra.no-host-available-retry-timeout")
    public CassandraClientConfig setNoHostAvailableRetryTimeout(Duration noHostAvailableRetryTimeout) {
        this.noHostAvailableRetryTimeout = noHostAvailableRetryTimeout;
        return this;
    }

    public Optional<@Min(value=1L) Integer> getSpeculativeExecutionLimit() {
        return this.speculativeExecutionLimit;
    }

    @Config(value="cassandra.speculative-execution.limit")
    public CassandraClientConfig setSpeculativeExecutionLimit(Integer speculativeExecutionLimit) {
        this.speculativeExecutionLimit = Optional.ofNullable(speculativeExecutionLimit);
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getSpeculativeExecutionDelay() {
        return this.speculativeExecutionDelay;
    }

    @Config(value="cassandra.speculative-execution.delay")
    public CassandraClientConfig setSpeculativeExecutionDelay(Duration speculativeExecutionDelay) {
        this.speculativeExecutionDelay = speculativeExecutionDelay;
        return this;
    }

    @Nullable
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Config(value="cassandra.protocol-version")
    public CassandraClientConfig setProtocolVersion(DefaultProtocolVersion version) {
        this.protocolVersion = version;
        return this;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="cassandra.tls.enabled")
    public CassandraClientConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public CassandraAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Config(value="cassandra.security")
    public CassandraClientConfig setAuthenticationType(CassandraAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public static enum CassandraAuthenticationType {
        NONE,
        PASSWORD;

    }
}

