/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.specex.ConstantSpeculativeExecutionPolicy;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraTelemetry;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.cassandra.CassandraClientConfig;
import io.trino.plugin.cassandra.CassandraConnector;
import io.trino.plugin.cassandra.CassandraMetadata;
import io.trino.plugin.cassandra.CassandraPageSinkProvider;
import io.trino.plugin.cassandra.CassandraPartitionManager;
import io.trino.plugin.cassandra.CassandraPasswordConfig;
import io.trino.plugin.cassandra.CassandraRecordSetProvider;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraSessionConfigurator;
import io.trino.plugin.cassandra.CassandraSessionProperties;
import io.trino.plugin.cassandra.CassandraSplitManager;
import io.trino.plugin.cassandra.CassandraTokenSplitManager;
import io.trino.plugin.cassandra.CassandraTypeManager;
import io.trino.plugin.cassandra.ExecuteProcedure;
import io.trino.plugin.cassandra.ExtraColumnMetadata;
import io.trino.plugin.cassandra.ptf.Query;
import io.trino.plugin.cassandra.tls.CassandraTlsModule;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CassandraClientModule
extends AbstractConfigurationAwareModule {
    private final TypeManager typeManager;

    public CassandraClientModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void setup(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(CassandraConnector.class).in(Scopes.SINGLETON);
        binder.bind(CassandraMetadata.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraTokenSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraPartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSessionProperties.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(ExecuteProcedure.class).in(Scopes.SINGLETON);
        binder.bind(CassandraTypeManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CassandraClientConfig.class);
        this.install(ConditionalModule.conditionalModule(CassandraClientConfig.class, CassandraClientConfig::isTlsEnabled, (Module)new CassandraTlsModule()));
        this.install(ConditionalModule.conditionalModule(CassandraClientConfig.class, config -> config.getAuthenticationType() == CassandraClientConfig.CassandraAuthenticationType.PASSWORD, (Module)new PasswordAuthenticationModule()));
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(ExtraColumnMetadata.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        Multibinder.newSetBinder((Binder)binder, CassandraSessionConfigurator.class);
        ClosingBinder.closingBinder((Binder)binder).registerCloseable(CassandraSession.class);
    }

    @Singleton
    @Provides
    public static CassandraSession createCassandraSession(CassandraTypeManager cassandraTypeManager, CassandraClientConfig config, Set<CassandraSessionConfigurator> sessionConfigurators, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec, OpenTelemetry openTelemetry) {
        Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
        CqlSessionBuilder cqlSessionBuilder = CqlSession.builder();
        List<String> contactPoints = Objects.requireNonNull(config.getContactPoints(), "contactPoints is null");
        Preconditions.checkArgument((!contactPoints.isEmpty() ? 1 : 0) != 0, (Object)"empty contactPoints");
        for (CassandraSessionConfigurator sessionConfigurator : sessionConfigurators) {
            sessionConfigurator.configure(cqlSessionBuilder);
        }
        return new CassandraSession(cassandraTypeManager, extraColumnMetadataCodec, () -> {
            contactPoints.forEach(contactPoint -> cqlSessionBuilder.addContactPoint(CassandraClientModule.createInetSocketAddress(contactPoint, config.getNativeProtocolPort())));
            CassandraTelemetry cassandraTelemetry = CassandraTelemetry.create((OpenTelemetry)openTelemetry);
            return cassandraTelemetry.wrap((CqlSession)cqlSessionBuilder.build());
        }, config.getNoHostAvailableRetryTimeout());
    }

    @ProvidesIntoSet
    @Singleton
    public CassandraSessionConfigurator configurationLoaderConfigurator(CassandraClientConfig config) {
        return builder -> {
            ProgrammaticDriverConfigLoaderBuilder driverConfigLoaderBuilder = DriverConfigLoader.programmaticBuilder();
            driverConfigLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, List.of());
            if (config.getProtocolVersion() != null) {
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.PROTOCOL_VERSION, config.getProtocolVersion().name());
            }
            driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, ExponentialReconnectionPolicy.class.getName());
            driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofMillis(500L));
            driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.ofSeconds(10L));
            driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.RETRY_POLICY_CLASS, config.getRetryPolicy().getPolicyClass().getName());
            driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, DefaultLoadBalancingPolicy.class.getName());
            if (config.isUseDCAware()) {
                Objects.requireNonNull(config.getDcAwareLocalDC(), "DCAwarePolicy localDC is null");
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, config.getDcAwareLocalDC());
                if (config.getDcAwareUsedHostsPerRemoteDc() > 0) {
                    driverConfigLoaderBuilder.withInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC, config.getDcAwareUsedHostsPerRemoteDc().intValue());
                    if (config.isDcAwareAllowRemoteDCsForLocal()) {
                        driverConfigLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS, true);
                    }
                }
            }
            driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, config.getClientReadTimeout().toJavaTime());
            driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, config.getClientConnectTimeout().toJavaTime());
            if (config.getClientSoLinger() != null) {
                driverConfigLoaderBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_LINGER_INTERVAL, config.getClientSoLinger().intValue());
            }
            driverConfigLoaderBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, config.getFetchSize());
            driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, config.getConsistencyLevel().name());
            if (config.getSpeculativeExecutionLimit().isPresent()) {
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS, ConstantSpeculativeExecutionPolicy.class.getName());
                driverConfigLoaderBuilder.withInt((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_MAX, config.getSpeculativeExecutionLimit().get().intValue());
                driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY, Duration.ofMillis(config.getSpeculativeExecutionDelay().toMillis()));
            }
            builder.withConfigLoader(driverConfigLoaderBuilder.build());
        };
    }

    private static InetSocketAddress createInetSocketAddress(String contactPoint, int port) {
        try {
            return new InetSocketAddress(InetAddress.getByName(contactPoint), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to add contact point: " + contactPoint, e);
        }
    }

    private static class PasswordAuthenticationModule
    implements Module {
        private PasswordAuthenticationModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(CassandraPasswordConfig.class);
        }

        @ProvidesIntoSet
        @Singleton
        public CassandraSessionConfigurator passwordAuthenticationConfigurator(CassandraPasswordConfig config) {
            return builder -> builder.withAuthCredentials(config.getUsername(), config.getPassword());
        }
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeId.of((String)value));
        }
    }
}

