/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;

public record CassandraColumnHandle(String name, int ordinalPosition, CassandraType cassandraType, boolean partitionKey, boolean clusteringKey, boolean indexed, boolean hidden) implements ColumnHandle
{
    public CassandraColumnHandle {
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinalPosition is negative");
        Objects.requireNonNull(cassandraType, "cassandraType is null");
    }

    @JsonIgnore
    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(CassandraCqlUtils.cqlNameToSqlName(this.name)).setType(this.cassandraType.trinoType()).setHidden(this.hidden).build();
    }

    @JsonIgnore
    public Type getType() {
        return this.cassandraType.trinoType();
    }
}

