/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public record CassandraInsertTableHandle(String schemaName, String tableName, List<String> columnNames, List<Type> columnTypes, boolean generateUuid) implements ConnectorInsertTableHandle
{
    public CassandraInsertTableHandle {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Objects.requireNonNull(columnTypes, "columnTypes is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        columnNames = ImmutableList.copyOf(columnNames);
        columnTypes = ImmutableList.copyOf(columnTypes);
    }

    @Override
    public String toString() {
        return "cassandra:" + this.schemaName + "." + this.tableName;
    }
}

