/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.trino.plugin.cassandra.CassandraClientConfig;
import io.trino.plugin.cassandra.CassandraClusteringPredicatesExtractor;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraInsertTableHandle;
import io.trino.plugin.cassandra.CassandraNamedRelationHandle;
import io.trino.plugin.cassandra.CassandraOutputTableHandle;
import io.trino.plugin.cassandra.CassandraPartition;
import io.trino.plugin.cassandra.CassandraPartitionManager;
import io.trino.plugin.cassandra.CassandraPartitionResult;
import io.trino.plugin.cassandra.CassandraQueryRelationHandle;
import io.trino.plugin.cassandra.CassandraRelationHandle;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraTable;
import io.trino.plugin.cassandra.CassandraTableHandle;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.CassandraTypeManager;
import io.trino.plugin.cassandra.CassandraTypes;
import io.trino.plugin.cassandra.ExtraColumnMetadata;
import io.trino.plugin.cassandra.ptf.Query;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class CassandraMetadata
implements ConnectorMetadata {
    public static final String PRESTO_COMMENT_METADATA = "Presto Metadata:";
    private final CassandraSession cassandraSession;
    private final CassandraPartitionManager partitionManager;
    private final boolean allowDropTable;
    private final JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec;
    private final CassandraTypeManager cassandraTypeManager;

    @Inject
    public CassandraMetadata(CassandraSession cassandraSession, CassandraPartitionManager partitionManager, JsonCodec<List<ExtraColumnMetadata>> extraColumnMetadataCodec, CassandraTypeManager cassandraTypeManager, CassandraClientConfig config) {
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
        this.cassandraTypeManager = Objects.requireNonNull(cassandraTypeManager, "cassandraTypeManager is null");
        this.allowDropTable = config.getAllowDropTable();
        this.extraColumnMetadataCodec = Objects.requireNonNull(extraColumnMetadataCodec, "extraColumnMetadataCodec is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.cassandraSession.getCaseSensitiveSchemaNames().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    public CassandraTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        Objects.requireNonNull(tableName, "tableName is null");
        try {
            return new CassandraTableHandle(this.cassandraSession.getTable(tableName).tableHandle());
        }
        catch (SchemaNotFoundException | TableNotFoundException e) {
            return null;
        }
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return ((CassandraTableHandle)tableHandle).getRequiredNamedRelation().getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        CassandraTableHandle handle = (CassandraTableHandle)tableHandle;
        CassandraRelationHandle cassandraRelationHandle = handle.relationHandle();
        if (cassandraRelationHandle instanceof CassandraQueryRelationHandle) {
            CassandraQueryRelationHandle queryRelationHandle = (CassandraQueryRelationHandle)cassandraRelationHandle;
            List columns = (List)this.getColumnHandles(queryRelationHandle.getQuery()).stream().map(CassandraColumnHandle.class::cast).map(CassandraColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
            return new ConnectorTableMetadata(CassandraMetadata.getSchemaTableName(handle), columns);
        }
        return this.getTableMetadata(CassandraMetadata.getTableName(tableHandle));
    }

    private static SchemaTableName getSchemaTableName(CassandraTableHandle handle) {
        return handle.isNamedRelation() ? handle.getRequiredNamedRelation().getSchemaTableName() : new SchemaTableName("_generated", "_generated_query");
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        CassandraTable table = this.cassandraSession.getTable(tableName);
        List columns = table.columns().stream().map(CassandraColumnHandle::getColumnMetadata).collect(Collectors.toList());
        return new ConnectorTableMetadata(tableName, columns);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName1) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        List<String> schemaNames = this.listSchemas(session, schemaName1);
        for (String schemaName : schemaNames) {
            try {
                for (String tableName : this.cassandraSession.getCaseSensitiveTableNames(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase(Locale.ENGLISH)));
                }
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        return (List)schemaName.map(ImmutableList::of).orElseGet(() -> (ImmutableList)this.listSchemaNames(session));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        CassandraTable table = this.cassandraSession.getTable(CassandraMetadata.getTableName(tableHandle));
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (CassandraColumnHandle columnHandle : table.columns()) {
            columnHandles.put((Object)CassandraCqlUtils.cqlNameToSqlName(columnHandle.name()).toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        return columnHandles.buildOrThrow();
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        HashMap<SchemaTableName, RelationColumnsMetadata> relationColumns = new HashMap<SchemaTableName, RelationColumnsMetadata>();
        for (CassandraTable table : this.listCassandraTables(session, schemaName)) {
            try {
                SchemaTableName tableName = table.tableHandle().getSchemaTableName();
                relationColumns.put(tableName, RelationColumnsMetadata.forTable((SchemaTableName)tableName, (List)((List)table.columns().stream().map(CassandraColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList()))));
            }
            catch (NotFoundException notFoundException) {}
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    private List<CassandraTable> listCassandraTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (String schema : this.listSchemas(session, schemaName)) {
            try {
                this.cassandraSession.listTables(schema).forEach(arg_0 -> ((ImmutableList.Builder)tables).add(arg_0));
            }
            catch (SchemaNotFoundException schemaNotFoundException) {}
        }
        return tables.build();
    }

    public Iterator<RelationCommentMetadata> streamRelationComments(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        HashMap<SchemaTableName, RelationCommentMetadata> relationColumns = new HashMap<SchemaTableName, RelationCommentMetadata>();
        for (SchemaTableName schemaTableName : this.listTables(session, schemaName)) {
            relationColumns.put(schemaTableName, RelationCommentMetadata.forRelation((SchemaTableName)schemaTableName, Optional.empty()));
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((CassandraColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle connectorTableHandle, Constraint constraint) {
        TupleDomain<ColumnHandle> unenforcedConstraint;
        CassandraTableHandle tableHandle = (CassandraTableHandle)connectorTableHandle;
        if (tableHandle.isSynthetic()) {
            return Optional.empty();
        }
        CassandraNamedRelationHandle handle = tableHandle.getRequiredNamedRelation();
        if (handle.getPartitions().isPresent() || !handle.getClusteringKeyPredicates().isEmpty()) {
            return Optional.empty();
        }
        CassandraPartitionResult partitionResult = this.partitionManager.getPartitions(handle, (TupleDomain<ColumnHandle>)constraint.getSummary());
        String clusteringKeyPredicates = "";
        if (partitionResult.unpartitioned() || partitionResult.indexedColumnPredicatePushdown()) {
            unenforcedConstraint = partitionResult.unenforcedConstraint();
        } else {
            CassandraClusteringPredicatesExtractor clusteringPredicatesExtractor = new CassandraClusteringPredicatesExtractor(this.cassandraTypeManager, this.cassandraSession.getTable(handle.getSchemaTableName()).clusteringKeyColumns(), partitionResult.unenforcedConstraint());
            clusteringKeyPredicates = clusteringPredicatesExtractor.getClusteringKeyPredicates();
            unenforcedConstraint = clusteringPredicatesExtractor.getUnenforcedConstraints();
        }
        Optional<List<CassandraPartition>> currentPartitions = handle.getPartitions();
        if (currentPartitions.isPresent() && currentPartitions.get().containsAll(partitionResult.partitions()) && handle.getClusteringKeyPredicates().equals(clusteringKeyPredicates)) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new CassandraTableHandle(new CassandraNamedRelationHandle(handle.getSchemaName(), handle.getTableName(), Optional.of(partitionResult.partitions()), clusteringKeyPredicates)), unenforcedConstraint, constraint.getExpression(), false));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        this.createTable(tableMetadata);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraTableHandle), (Object)"tableHandle is not an instance of CassandraTableHandle");
        if (!this.allowDropTable) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this Cassandra catalog");
        }
        CassandraNamedRelationHandle cassandraTableHandle = ((CassandraTableHandle)tableHandle).getRequiredNamedRelation();
        if (this.cassandraSession.isMaterializedView(cassandraTableHandle.getSchemaTableName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Dropping materialized views not yet supported");
        }
        this.cassandraSession.execute(String.format("DROP TABLE \"%s\".\"%s\"", cassandraTableHandle.getSchemaName(), cassandraTableHandle.getTableName()));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        if (replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        return this.createTable(tableMetadata);
    }

    private CassandraOutputTableHandle createTable(ConnectorTableMetadata tableMetadata) {
        if (tableMetadata.getComment().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with table comment");
        }
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        ImmutableList.Builder columnExtra = ImmutableList.builder();
        columnExtra.add((Object)new ExtraColumnMetadata("id", true));
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (column.getComment() != null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with column comment");
            }
            columnNames.add((Object)column.getName());
            columnTypes.add((Object)column.getType());
            columnExtra.add((Object)new ExtraColumnMetadata(column.getName(), column.isHidden()));
        }
        SchemaTableName table = tableMetadata.getTable();
        String schemaName = this.cassandraSession.getCaseSensitiveSchemaName(table.getSchemaName());
        String tableName = table.getTableName();
        ImmutableList columns = columnNames.build();
        ImmutableList types = columnTypes.build();
        StringBuilder queryBuilder = new StringBuilder(String.format("CREATE TABLE \"%s\".\"%s\"(%s uuid primary key", schemaName, tableName, "id"));
        for (int i = 0; i < columns.size(); ++i) {
            String name = (String)columns.get(i);
            Type type = (Type)types.get(i);
            queryBuilder.append(", ").append(CassandraCqlUtils.validColumnName(name)).append(" ").append(this.cassandraTypeManager.toCassandraType(type, this.cassandraSession.getProtocolVersion()).kind().name().toLowerCase(Locale.ENGLISH));
        }
        queryBuilder.append(") ");
        String columnMetadata = this.extraColumnMetadataCodec.toJson((Object)columnExtra.build());
        queryBuilder.append("WITH comment=").append(CassandraCqlUtils.quoteStringLiteral("Presto Metadata: " + columnMetadata));
        this.cassandraSession.execute(queryBuilder.toString());
        return new CassandraOutputTableHandle(schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build());
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        CassandraNamedRelationHandle table = ((CassandraTableHandle)tableHandle).getRequiredNamedRelation();
        this.cassandraSession.execute((Statement<?>)QueryBuilder.truncate((String)CassandraCqlUtils.validSchemaName(table.getSchemaName()), (String)CassandraCqlUtils.validTableName(table.getTableName())).build());
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> insertedColumns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        CassandraNamedRelationHandle table = ((CassandraTableHandle)tableHandle).getRequiredNamedRelation();
        if (this.cassandraSession.isMaterializedView(table.getSchemaTableName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Inserting into materialized views not yet supported");
        }
        SchemaTableName schemaTableName = new SchemaTableName(table.getSchemaName(), table.getTableName());
        List<CassandraColumnHandle> columns = this.cassandraSession.getTable(schemaTableName).columns();
        List<String> columnNames = columns.stream().filter(columnHandle -> !CassandraMetadata.isHiddenIdColumn(columnHandle)).map(CassandraColumnHandle::name).collect(Collectors.toList());
        List<Type> columnTypes = columns.stream().filter(columnHandle -> !CassandraMetadata.isHiddenIdColumn(columnHandle)).map(CassandraColumnHandle::getType).collect(Collectors.toList());
        boolean generateUuid = ((Optional)columns.stream().filter(CassandraMetadata::isHiddenIdColumn).collect(MoreCollectors.toOptional())).isPresent();
        return new CassandraInsertTableHandle(table.getSchemaName(), table.getTableName(), columnNames, columnTypes, generateUuid);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    private static boolean isHiddenIdColumn(CassandraColumnHandle columnHandle) {
        return columnHandle.hidden() && "id".equals(columnHandle.name());
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateCaseColumns, RetryMode retryMode) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Delete without primary key or partition key is not supported");
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new CassandraColumnHandle("$update_row_id", 0, CassandraTypes.TEXT, false, false, false, true);
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle deleteHandle) {
        CassandraNamedRelationHandle handle = ((CassandraTableHandle)deleteHandle).getRequiredNamedRelation();
        List<CassandraPartition> partitions = handle.getPartitions().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Deleting without partition key is not supported"));
        if (partitions.isEmpty()) {
            return OptionalLong.empty();
        }
        for (String cql : CassandraCqlUtils.getDeleteQueries(handle)) {
            this.cassandraSession.execute(cql);
        }
        return OptionalLong.empty();
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof Query.QueryHandle)) {
            return Optional.empty();
        }
        Query.QueryHandle queryHandle = (Query.QueryHandle)handle;
        CassandraTableHandle tableHandle = queryHandle.tableHandle();
        List<ColumnHandle> columnHandles = this.getColumnHandles(((CassandraQueryRelationHandle)tableHandle.relationHandle()).getQuery());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, columnHandles));
    }

    public List<ColumnHandle> getColumnHandles(String query) {
        PreparedStatement statement = this.cassandraSession.prepare(SimpleStatement.newInstance((String)query));
        int position = 0;
        ImmutableList.Builder columnsBuilder = ImmutableList.builderWithExpectedSize((int)statement.getResultSetDefinitions().size());
        for (ColumnDefinition column : statement.getResultSetDefinitions()) {
            CassandraType cassandraType = this.cassandraTypeManager.toCassandraType(column.getType()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(column.getType())));
            columnsBuilder.add((Object)new CassandraColumnHandle(column.getName().asInternal(), position++, cassandraType, false, false, false, false));
        }
        return columnsBuilder.build();
    }
}

