/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.cassandra.CassandraPartition;
import io.trino.plugin.cassandra.CassandraRelationHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CassandraNamedRelationHandle
extends CassandraRelationHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<List<CassandraPartition>> partitions;
    private final String clusteringKeyPredicates;

    public CassandraNamedRelationHandle(String schemaName, String tableName) {
        this(schemaName, tableName, Optional.empty(), "");
    }

    @JsonCreator
    public CassandraNamedRelationHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partitions") Optional<List<CassandraPartition>> partitions, @JsonProperty(value="clusteringKeyPredicates") String clusteringKeyPredicates) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitions = partitions.map(ImmutableList::copyOf);
        this.clusteringKeyPredicates = Objects.requireNonNull(clusteringKeyPredicates, "clusteringKeyPredicates is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<List<CassandraPartition>> getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public String getClusteringKeyPredicates() {
        return this.clusteringKeyPredicates;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.partitions, this.clusteringKeyPredicates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraNamedRelationHandle other = (CassandraNamedRelationHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.partitions, other.partitions) && Objects.equals(this.clusteringKeyPredicates, other.clusteringKeyPredicates);
    }

    @Override
    public String toString() {
        Object result = String.format("%s:%s", this.schemaName, this.tableName);
        if (this.partitions.isPresent()) {
            List<CassandraPartition> partitions = this.partitions.get();
            result = (String)result + String.format(" %d partitions %s", partitions.size(), Stream.concat(partitions.subList(0, Math.min(partitions.size(), 3)).stream(), partitions.size() > 3 ? Stream.of("...") : Stream.of(new Object[0])).map(Object::toString).collect(Collectors.joining(", ", "[", "]")));
        }
        if (!this.clusteringKeyPredicates.isEmpty()) {
            result = (String)result + String.format(" constraint(%s)", this.clusteringKeyPredicates);
        }
        return result;
    }
}

