/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class CassandraPartition {
    static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    public static final CassandraPartition UNPARTITIONED = new CassandraPartition();
    private final String partitionId;
    private final byte[] key;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final boolean indexedColumnPredicatePushdown;

    private CassandraPartition() {
        this.partitionId = UNPARTITIONED_ID;
        this.tupleDomain = TupleDomain.all();
        this.key = null;
        this.indexedColumnPredicatePushdown = false;
    }

    @JsonCreator
    public CassandraPartition(@JsonProperty(value="key") byte[] key, @JsonProperty(value="partitionId") String partitionId, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain, @JsonProperty(value="indexedColumnPredicatePushdown") boolean indexedColumnPredicatePushdown) {
        this.key = key;
        this.partitionId = partitionId;
        this.tupleDomain = tupleDomain;
        this.indexedColumnPredicatePushdown = indexedColumnPredicatePushdown;
    }

    public boolean isUnpartitioned() {
        return this.partitionId.equals(UNPARTITIONED_ID);
    }

    @JsonProperty
    public boolean isIndexedColumnPredicatePushdown() {
        return this.indexedColumnPredicatePushdown;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    @JsonProperty
    public String getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        return this.partitionId;
    }

    public ByteBuffer getKeyAsByteBuffer() {
        return ByteBuffer.wrap(this.key);
    }

    @JsonProperty
    public byte[] getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraPartition other = (CassandraPartition)obj;
        return Objects.equals(this.partitionId, other.partitionId) && Arrays.equals(this.key, other.key) && Objects.equals(this.tupleDomain, other.tupleDomain) && this.indexedColumnPredicatePushdown == other.indexedColumnPredicatePushdown;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, Arrays.hashCode(this.key), this.tupleDomain, this.indexedColumnPredicatePushdown);
    }
}

