/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.plugin.cassandra.CassandraPartition;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record CassandraPartitionResult(List<CassandraPartition> partitions, TupleDomain<ColumnHandle> unenforcedConstraint) {
    public CassandraPartitionResult {
        partitions = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
    }

    public boolean unpartitioned() {
        return this.partitions.size() == 1 && ((CassandraPartition)Iterables.getOnlyElement(this.partitions)).isUnpartitioned();
    }

    public boolean indexedColumnPredicatePushdown() {
        return this.partitions.size() == 1 && ((CassandraPartition)Iterables.getOnlyElement(this.partitions)).isIndexedColumnPredicatePushdown();
    }
}

