/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.CassandraTypeManager;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CassandraRecordCursor
implements RecordCursor {
    private final List<String> columnNames;
    private final List<CassandraType> cassandraTypes;
    private final CassandraTypeManager cassandraTypeManager;
    private final ResultSet rs;
    private Row currentRow;

    public CassandraRecordCursor(CassandraSession cassandraSession, CassandraTypeManager cassandraTypeManager, List<String> columnNames, List<CassandraType> cassandraTypes, String cql) {
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.cassandraTypes = cassandraTypes;
        Preconditions.checkArgument((columnNames.size() == cassandraTypes.size() ? 1 : 0) != 0, (Object)"columnNames and cassandraTypes sizes don't match");
        this.cassandraTypeManager = cassandraTypeManager;
        this.rs = cassandraSession.execute(cql);
        this.currentRow = null;
    }

    public boolean advanceNextPosition() {
        Row row = (Row)this.rs.one();
        if (row != null) {
            this.currentRow = row;
            return true;
        }
        return false;
    }

    public void close() {
    }

    public boolean getBoolean(int i) {
        return this.currentRow.getBoolean(CassandraCqlUtils.validColumnName(this.columnNames.get(i)));
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public double getDouble(int i) {
        String columnName = CassandraCqlUtils.validColumnName(this.columnNames.get(i));
        return switch (this.getCassandraType(i).kind()) {
            case CassandraType.Kind.DOUBLE -> this.currentRow.getDouble(columnName);
            case CassandraType.Kind.FLOAT -> this.currentRow.getFloat(columnName);
            case CassandraType.Kind.DECIMAL -> this.currentRow.getBigDecimal(columnName).doubleValue();
            default -> throw new IllegalStateException("Cannot retrieve double for " + String.valueOf(this.getCassandraType(i)));
        };
    }

    public long getLong(int i) {
        String columnName = CassandraCqlUtils.validColumnName(this.columnNames.get(i));
        return switch (this.getCassandraType(i).kind()) {
            case CassandraType.Kind.INT -> this.currentRow.getInt(columnName);
            case CassandraType.Kind.SMALLINT -> this.currentRow.getShort(columnName);
            case CassandraType.Kind.TINYINT -> this.currentRow.getByte(columnName);
            case CassandraType.Kind.BIGINT, CassandraType.Kind.COUNTER -> this.currentRow.getLong(columnName);
            case CassandraType.Kind.TIME -> this.currentRow.getLocalTime(columnName).toNanoOfDay() * 1000L;
            case CassandraType.Kind.TIMESTAMP -> DateTimeEncoding.packDateTimeWithZone((long)this.currentRow.getInstant(columnName).toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
            case CassandraType.Kind.DATE -> this.currentRow.getLocalDate(columnName).toEpochDay();
            case CassandraType.Kind.FLOAT -> Float.floatToRawIntBits(this.currentRow.getFloat(columnName));
            default -> throw new IllegalStateException("Cannot retrieve long for " + String.valueOf(this.getCassandraType(i)));
        };
    }

    private CassandraType getCassandraType(int i) {
        return this.cassandraTypes.get(i);
    }

    public Slice getSlice(int i) {
        if (this.getCassandraType(i).kind() == CassandraType.Kind.TIMESTAMP) {
            throw new IllegalArgumentException("Timestamp column can not be accessed with getSlice");
        }
        NullableValue value = this.cassandraTypeManager.getColumnValue(this.cassandraTypes.get(i), this.currentRow, this.currentRow.firstIndexOf(CassandraCqlUtils.validColumnName(this.columnNames.get(i))));
        if (value.getValue() instanceof Slice) {
            return (Slice)value.getValue();
        }
        return Slices.utf8Slice((String)value.getValue().toString());
    }

    public Object getObject(int i) {
        CassandraType cassandraType = this.cassandraTypes.get(i);
        switch (cassandraType.kind()) {
            case TUPLE: 
            case UDT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("getObject cannot be called for " + String.valueOf(cassandraType));
            }
        }
        return this.cassandraTypeManager.getColumnValue(cassandraType, this.currentRow, this.currentRow.firstIndexOf(CassandraCqlUtils.validColumnName(this.columnNames.get(i)))).getValue();
    }

    public Type getType(int i) {
        return this.getCassandraType(i).trinoType();
    }

    public boolean isNull(int i) {
        String columnName = CassandraCqlUtils.validColumnName(this.columnNames.get(i));
        if (this.getCassandraType(i).kind() == CassandraType.Kind.TIMESTAMP) {
            return this.currentRow.getInstant(columnName) == null;
        }
        return this.currentRow.isNull(columnName);
    }
}

