/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public record CassandraSplit(String partitionId, String splitCondition, List<HostAddress> addresses) implements ConnectorSplit
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CassandraSplit.class);

    public CassandraSplit {
        Objects.requireNonNull(partitionId, "partitionId is null");
        addresses = ImmutableList.copyOf(addresses);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.partitionId) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.splitCondition);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.partitionId).toString();
    }

    public String getWhereClause() {
        if (this.partitionId.equals("<UNPARTITIONED>")) {
            if (this.splitCondition != null) {
                return " WHERE " + this.splitCondition;
            }
            return "";
        }
        if (this.splitCondition != null) {
            return " WHERE " + this.partitionId + " AND " + this.splitCondition;
        }
        return " WHERE " + this.partitionId;
    }
}

