/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import io.trino.plugin.cassandra.CassandraNamedRelationHandle;
import io.trino.plugin.cassandra.CassandraRelationHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import java.util.Objects;

public record CassandraTableHandle(CassandraRelationHandle relationHandle) implements ConnectorTableHandle
{
    public CassandraTableHandle {
        Objects.requireNonNull(relationHandle, "relationHandle is null");
    }

    @JsonIgnore
    public CassandraNamedRelationHandle getRequiredNamedRelation() {
        Preconditions.checkState((boolean)this.isNamedRelation(), (String)"The table handle does not represent a named relation: %s", (Object)this);
        return (CassandraNamedRelationHandle)this.relationHandle;
    }

    @JsonIgnore
    public boolean isSynthetic() {
        return !this.isNamedRelation();
    }

    @JsonIgnore
    public boolean isNamedRelation() {
        return this.relationHandle instanceof CassandraNamedRelationHandle;
    }
}

