/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.ptf;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorTableFunction;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraMetadata;
import io.trino.plugin.cassandra.CassandraQueryRelationHandle;
import io.trino.plugin.cassandra.CassandraTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Query
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "query";
    private final CassandraMetadata cassandraMetadata;

    @Inject
    public Query(CassandraMetadata cassandraMetadata) {
        this.cassandraMetadata = Objects.requireNonNull(cassandraMetadata, "cassandraMetadata is null");
    }

    public ConnectorTableFunction get() {
        return new ClassLoaderSafeConnectorTableFunction((ConnectorTableFunction)new QueryFunction(this.cassandraMetadata), this.getClass().getClassLoader());
    }

    public static class QueryFunction
    extends AbstractConnectorTableFunction {
        private final CassandraMetadata cassandraMetadata;

        public QueryFunction(CassandraMetadata cassandraMetadata) {
            super(Query.SCHEMA_NAME, Query.NAME, (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.cassandraMetadata = Objects.requireNonNull(cassandraMetadata, "metadata is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            List<ColumnHandle> columnHandles;
            ScalarArgument argument = (ScalarArgument)Iterables.getOnlyElement(arguments.values());
            String query = ((Slice)argument.getValue()).toStringUtf8();
            CassandraQueryRelationHandle queryRelationHandle = new CassandraQueryRelationHandle(query);
            try {
                columnHandles = this.cassandraMetadata.getColumnHandles(query);
            }
            catch (UndeclaredThrowableException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot get column definition", Throwables.getRootCause((Throwable)e));
            }
            if (columnHandles.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot get column definition");
            }
            Descriptor returnedType = new Descriptor((List)columnHandles.stream().map(CassandraColumnHandle.class::cast).map(column -> new Descriptor.Field(column.name(), Optional.of(column.getType()))).collect(ImmutableList.toImmutableList()));
            QueryHandle handle = new QueryHandle(new CassandraTableHandle(queryRelationHandle));
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public record QueryHandle(CassandraTableHandle tableHandle) implements ConnectorTableFunctionHandle
    {
        public QueryHandle {
            Objects.requireNonNull(tableHandle, "tableHandle is null");
        }
    }
}

