/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.tls;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import java.io.File;
import java.util.Optional;

public class CassandraTlsConfig {
    private File keystorePath;
    private String keystorePassword;
    private File truststorePath;
    private String truststorePassword;

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="cassandra.tls.keystore-path")
    public CassandraTlsConfig setKeystorePath(File keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="cassandra.tls.keystore-password")
    @ConfigSecuritySensitive
    public CassandraTlsConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public Optional<@FileExists File> getTruststorePath() {
        return Optional.ofNullable(this.truststorePath);
    }

    @Config(value="cassandra.tls.truststore-path")
    public CassandraTlsConfig setTruststorePath(File truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="cassandra.tls.truststore-password")
    @ConfigSecuritySensitive
    public CassandraTlsConfig setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }
}

