/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.util;

import com.datastax.oss.driver.api.core.metadata.Node;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostAddressFactory {
    private final Map<String, HostAddress> hostMap = new HashMap<String, HostAddress>();

    public HostAddress toHostAddress(Node node) {
        SocketAddress address = node.getEndPoint().resolve();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            return this.toHostAddress(inetSocketAddress.getAddress().getHostAddress());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Only endpoints which resolve to a InetSocketAddress are supported. Resolving to socket addresses of type %s is not supported", address.getClass().getName()));
    }

    public List<HostAddress> toHostAddressList(Collection<Node> nodes) {
        ArrayList<HostAddress> list = new ArrayList<HostAddress>(nodes.size());
        for (Node node : nodes) {
            list.add(this.toHostAddress(node));
        }
        return list;
    }

    public HostAddress toHostAddress(String hostAddressName) {
        HostAddress address = this.hostMap.get(hostAddressName);
        if (address == null) {
            address = HostAddress.fromString((String)hostAddressName);
            this.hostMap.put(hostAddressName, address);
        }
        return address;
    }

    public List<HostAddress> hostAddressNamesToHostAddressList(Collection<String> hosts) {
        ArrayList<HostAddress> list = new ArrayList<HostAddress>(hosts.size());
        for (String host : hosts) {
            list.add(this.toHostAddress(host));
        }
        return list;
    }
}

