/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cli;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import io.trino.cli.ClientOptions;
import io.trino.cli.Completion;
import io.trino.cli.Help;
import io.trino.cli.InputReader;
import io.trino.cli.Query;
import io.trino.cli.QueryPreprocessor;
import io.trino.cli.QueryPreprocessorException;
import io.trino.cli.QueryRunner;
import io.trino.cli.TableNameCompleter;
import io.trino.cli.TerminalUtils;
import io.trino.cli.ThreadInterruptor;
import io.trino.cli.Trino;
import io.trino.cli.lexer.StatementSplitter;
import io.trino.client.ClientSelectedRole;
import io.trino.client.ClientSession;
import io.trino.client.uri.PropertyName;
import io.trino.client.uri.TrinoUri;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import picocli.CommandLine;

@CommandLine.Command(name="trino", header={"Trino command line interface"}, synopsisHeading="%nUSAGE:%n%n", optionListHeading="%nOPTIONS:%n", usageHelpAutoWidth=true, versionProvider=Trino.VersionProvider.class)
public class Console
implements Callable<Integer> {
    public static final Set<String> STATEMENT_DELIMITERS = ImmutableSet.of((Object)";", (Object)"\\G");
    private static final String PROMPT_NAME = "trino";
    private static final Duration EXIT_DELAY = new Duration(3.0, TimeUnit.SECONDS);
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    public boolean usageHelpRequested;
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"Print version information and exit"})
    public boolean versionInfoRequested;
    @CommandLine.Mixin
    public ClientOptions clientOptions;

    @Override
    public Integer call() {
        return this.run() ? 0 : 1;
    }

    public boolean run() {
        CommandLine.ParseResult parseResult = this.spec.commandLine().getParseResult();
        Map restrictedOptions = (Map)this.spec.options().stream().filter(arg_0 -> ((CommandLine.ParseResult)parseResult).hasMatchedOption(arg_0)).map(option -> Console.getMapping(option.userObject()).map(value -> new AbstractMap.SimpleEntry<PropertyName, String>((PropertyName)value, option.longestName()))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        TrinoUri uri = this.clientOptions.getTrinoUri(restrictedOptions);
        ClientSession session = this.clientOptions.toClientSession(uri);
        boolean hasQuery = this.clientOptions.execute != null;
        boolean isFromFile = !Strings.isNullOrEmpty((String)this.clientOptions.file);
        String query = this.clientOptions.execute;
        if (hasQuery) {
            query = query + ";";
        }
        if (isFromFile) {
            if (hasQuery) {
                throw new RuntimeException("both --execute and --file specified");
            }
            try {
                query = Files.asCharSource((File)new File(this.clientOptions.file), (Charset)StandardCharsets.UTF_8).read();
                hasQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading from file %s: %s", this.clientOptions.file, e.getMessage()));
            }
        }
        if (!hasQuery && !TerminalUtils.isRealTerminal()) {
            try {
                if (System.in.available() > 0 && (query = new String(ByteStreams.toByteArray((InputStream)System.in), TerminalUtils.terminalEncoding()) + ";").length() > 1) {
                    hasQuery = true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        AtomicBoolean exiting = new AtomicBoolean();
        ThreadInterruptor interruptor = new ThreadInterruptor();
        CountDownLatch exited = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            exiting.set(true);
            interruptor.interrupt();
            boolean ignored = Uninterruptibles.awaitUninterruptibly((CountDownLatch)exited, (long)EXIT_DELAY.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            TerminalUtils.closeTerminal();
        }));
        try {
            QueryRunner queryRunner;
            block19: {
                queryRunner = new QueryRunner(uri, session, this.clientOptions.debug, this.clientOptions.networkLogging);
                try {
                    if (!hasQuery) break block19;
                    boolean bl = Console.executeCommand(queryRunner, exiting, query, this.clientOptions.outputFormat, this.clientOptions.ignoreErrors, this.clientOptions.progress.orElse(false));
                    queryRunner.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        queryRunner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Optional<String> pager = this.clientOptions.pager;
            Console.runConsole(queryRunner, exiting, this.clientOptions.outputFormatInteractive, this.clientOptions.editingMode, Console.getHistoryFile(this.clientOptions.historyFile), pager, this.clientOptions.progress.orElse(true), this.clientOptions.disableAutoSuggestion);
            boolean bl = true;
            queryRunner.close();
            return bl;
        }
        finally {
            exited.countDown();
            interruptor.close();
        }
    }

    private static Optional<PropertyName> getMapping(Object userObject) {
        if (userObject instanceof Field) {
            return Optional.ofNullable(((Field)userObject).getAnnotation(ClientOptions.PropertyMapping.class)).map(ClientOptions.PropertyMapping::value);
        }
        return Optional.empty();
    }

    private static void runConsole(QueryRunner queryRunner, AtomicBoolean exiting, ClientOptions.OutputFormat outputFormat, ClientOptions.EditingMode editingMode, Optional<Path> historyFile, Optional<String> pager, boolean progress, boolean disableAutoSuggestion) {
        try {
            TableNameCompleter tableNameCompleter = new TableNameCompleter(queryRunner);
            try (InputReader reader = new InputReader(editingMode, historyFile, disableAutoSuggestion, Completion.commandCompleter(), tableNameCompleter);){
                tableNameCompleter.populateCache();
                String remaining = "";
                block32: while (!exiting.get()) {
                    String line;
                    String prompt = PROMPT_NAME;
                    Optional schema = queryRunner.getSession().getSchema();
                    prompt = prompt + schema.map(value -> ":" + value.replace("%", "%%")).orElse("");
                    String commandPrompt = prompt + "> ";
                    try {
                        line = reader.readLine(commandPrompt, remaining);
                    }
                    catch (UserInterruptException e) {
                        if (!e.getPartialLine().isEmpty()) {
                            reader.getHistory().add(e.getPartialLine());
                        }
                        remaining = "";
                        continue;
                    }
                    catch (EndOfFileException e) {
                        System.out.println();
                        reader.close();
                        tableNameCompleter.close();
                        return;
                    }
                    String command = CharMatcher.is((char)';').or(CharMatcher.whitespace()).trimTrailingFrom((CharSequence)line);
                    switch (command.toLowerCase(Locale.ENGLISH)) {
                        case "exit": 
                        case "quit": {
                            return;
                        }
                        case "clear": {
                            Terminal terminal = reader.getTerminal();
                            terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
                            terminal.flush();
                            continue block32;
                        }
                        case "history": {
                            for (History.Entry entry : reader.getHistory()) {
                                System.out.println(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(6)).append((CharSequence)String.format("%5d", entry.index() + 1)).style(AttributedStyle.DEFAULT).append((CharSequence)"  ").append((CharSequence)entry.line()).toAnsi(reader.getTerminal()));
                            }
                            continue block32;
                        }
                        case "help": {
                            System.out.println();
                            System.out.println(Help.getHelpText());
                            continue block32;
                        }
                    }
                    StatementSplitter splitter = new StatementSplitter(line, STATEMENT_DELIMITERS);
                    for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
                        ClientOptions.OutputFormat currentOutputFormat = outputFormat;
                        if (split.terminator().equals("\\G")) {
                            currentOutputFormat = ClientOptions.OutputFormat.VERTICAL;
                        }
                        Console.process(queryRunner, split.statement(), currentOutputFormat, tableNameCompleter::populateCache, pager, progress, reader.getTerminal(), System.out, System.out);
                    }
                    remaining = CharMatcher.whitespace().trimTrailingFrom((CharSequence)splitter.getPartialStatement());
                }
            }
            finally {
                try {
                    tableNameCompleter.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private static boolean executeCommand(QueryRunner queryRunner, AtomicBoolean exiting, String query, ClientOptions.OutputFormat outputFormat, boolean ignoreErrors, boolean showProgress) {
        boolean success = true;
        StatementSplitter splitter = new StatementSplitter(query);
        for (StatementSplitter.Statement split : splitter.getCompleteStatements()) {
            if (!StatementSplitter.isEmptyStatement(split.statement()) && !Console.process(queryRunner, split.statement(), outputFormat, () -> {}, Optional.of(""), showProgress, TerminalUtils.getTerminal(), System.out, System.err)) {
                if (!ignoreErrors) {
                    return false;
                }
                success = false;
            }
            if (!exiting.get()) continue;
            return success;
        }
        if (!StatementSplitter.isEmptyStatement(splitter.getPartialStatement())) {
            System.err.println("Non-terminated statement: " + splitter.getPartialStatement());
            return false;
        }
        return success;
    }

    private static boolean process(QueryRunner queryRunner, String sql, ClientOptions.OutputFormat outputFormat, Runnable schemaChanged, Optional<String> pager, boolean showProgress, Terminal terminal, PrintStream out, PrintStream errorChannel) {
        String finalSql;
        try {
            finalSql = QueryPreprocessor.preprocessQuery(terminal, queryRunner.getSession().getCatalog(), queryRunner.getSession().getSchema(), sql);
        }
        catch (QueryPreprocessorException e) {
            System.err.println(e.getMessage());
            if (queryRunner.isDebug()) {
                e.printStackTrace(System.err);
            }
            return false;
        }
        Query query = queryRunner.startQuery(finalSql);
        try {
            ClientSession.Builder builder;
            boolean success = query.renderOutput(terminal, out, errorChannel, outputFormat, pager, showProgress);
            ClientSession session = queryRunner.getSession();
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                builder = ClientSession.builder((ClientSession)session);
                query.getSetCatalog().ifPresent(arg_0 -> ((ClientSession.Builder)builder).catalog(arg_0));
                query.getSetSchema().ifPresent(arg_0 -> ((ClientSession.Builder)builder).schema(arg_0));
                session = builder.build();
            }
            if (query.isClearTransactionId()) {
                session = ClientSession.stripTransactionId((ClientSession)session);
            }
            builder = ClientSession.builder((ClientSession)session);
            if (query.getStartedTransactionId() != null) {
                builder = builder.transactionId(query.getStartedTransactionId());
            }
            if (query.getSetPath().isPresent()) {
                builder = builder.path(query.getSetPath().get());
            }
            if (query.getSetAuthorizationUser().isPresent()) {
                builder = builder.authorizationUser(query.getSetAuthorizationUser());
                builder = builder.roles((Map)ImmutableMap.of());
            }
            if (query.isResetAuthorizationUser()) {
                builder = builder.authorizationUser(Optional.empty());
                builder = builder.roles((Map)ImmutableMap.of());
            }
            if (!query.getSetSessionProperties().isEmpty() || !query.getResetSessionProperties().isEmpty()) {
                HashMap<String, String> sessionProperties = new HashMap<String, String>(session.getProperties());
                sessionProperties.putAll(query.getSetSessionProperties());
                sessionProperties.keySet().removeAll(query.getResetSessionProperties());
                builder = builder.properties(sessionProperties);
            }
            if (!query.getSetRoles().isEmpty()) {
                HashMap<String, ClientSelectedRole> roles = new HashMap<String, ClientSelectedRole>(session.getRoles());
                roles.putAll(query.getSetRoles());
                builder = builder.roles(roles);
            }
            if (!query.getAddedPreparedStatements().isEmpty() || !query.getDeallocatedPreparedStatements().isEmpty()) {
                HashMap<String, String> preparedStatements = new HashMap<String, String>(session.getPreparedStatements());
                preparedStatements.putAll(query.getAddedPreparedStatements());
                preparedStatements.keySet().removeAll(query.getDeallocatedPreparedStatements());
                builder = builder.preparedStatements(preparedStatements);
            }
            session = builder.build();
            queryRunner.setSession(session);
            if (query.getSetCatalog().isPresent() || query.getSetSchema().isPresent()) {
                schemaChanged.run();
            }
            boolean bl = success;
            if (query != null) {
                query.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (query != null) {
                    try {
                        query.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                System.err.println(Trino.formatCliErrorMessage(e, queryRunner.isDebug()));
                return false;
            }
        }
    }

    private static Optional<Path> getHistoryFile(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(path, new String[0]));
    }
}

