/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.clickhouse.ClickHouseEngineType;
import io.trino.plugin.jdbc.TablePropertiesProvider;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ClickHouseTableProperties
implements TablePropertiesProvider {
    public static final String ENGINE_PROPERTY = "engine";
    public static final String ORDER_BY_PROPERTY = "order_by";
    public static final String PARTITION_BY_PROPERTY = "partition_by";
    public static final String PRIMARY_KEY_PROPERTY = "primary_key";
    public static final String SAMPLE_BY_PROPERTY = "sample_by";
    public static final ClickHouseEngineType DEFAULT_TABLE_ENGINE = ClickHouseEngineType.LOG;
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.of((Object)PropertyMetadata.enumProperty((String)"engine", (String)"ClickHouse Table Engine, defaults to Log", ClickHouseEngineType.class, (Enum)DEFAULT_TABLE_ENGINE, (boolean)false), (Object)new PropertyMetadata("order_by", "columns to be the sorting key, it's required for table MergeTree engine family", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value), (Object)new PropertyMetadata("partition_by", "columns to be the partition key. it's optional for table MergeTree engine family", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value), (Object)new PropertyMetadata("primary_key", "columns to be the primary key. it's optional for table MergeTree engine family", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value), (Object)PropertyMetadata.stringProperty((String)"sample_by", (String)"An expression for sampling. it's optional for table MergeTree engine family", null, (boolean)false));

    @Inject
    public ClickHouseTableProperties() {
    }

    public static ClickHouseEngineType getEngine(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        return (ClickHouseEngineType)((Object)tableProperties.get(ENGINE_PROPERTY));
    }

    public static List<String> getOrderBy(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        return (List)tableProperties.get(ORDER_BY_PROPERTY);
    }

    public static List<String> getPartitionBy(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        return (List)tableProperties.get(PARTITION_BY_PROPERTY);
    }

    public static List<String> getPrimaryKey(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        return (List)tableProperties.get(PRIMARY_KEY_PROPERTY);
    }

    public static Optional<String> getSampleBy(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        return Optional.ofNullable(tableProperties.get(SAMPLE_BY_PROPERTY)).map(String.class::cast);
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }
}

