/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JdbcRemoteIdentifiers
implements RemoteIdentifiers {
    private final BaseJdbcClient baseJdbcClient;
    private final Connection connection;
    private final boolean storesUpperCase;

    public JdbcRemoteIdentifiers(BaseJdbcClient baseJdbcClient, Connection connection, boolean storesUpperCase) {
        this.baseJdbcClient = Objects.requireNonNull(baseJdbcClient, "baseJdbcClient is null");
        this.connection = Objects.requireNonNull(connection, "connection is null");
        this.storesUpperCase = storesUpperCase;
    }

    public Set<String> getRemoteSchemas() {
        return (Set)this.baseJdbcClient.listSchemas(this.connection).stream().collect(ImmutableSet.toImmutableSet());
    }

    public Set<String> getRemoteTables(String remoteSchema) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = this.baseJdbcClient.getTables(this.connection, Optional.of(remoteSchema), Optional.empty());
            try {
                ImmutableSet.Builder tableNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    tableNames.add((Object)resultSet.getString("TABLE_NAME"));
                }
                immutableSet = tableNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    public boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCase;
    }

    public static class JdbcRemoteIdentifiersFactory {
        private final BaseJdbcClient baseJdbcClient;
        private Boolean storesUpperCaseIdentifiers;

        public JdbcRemoteIdentifiersFactory(BaseJdbcClient baseJdbcClient) {
            this.baseJdbcClient = Objects.requireNonNull(baseJdbcClient, "baseJdbcClient is null");
        }

        public JdbcRemoteIdentifiers createJdbcRemoteIdentifies(Connection connection) {
            return new JdbcRemoteIdentifiers(this.baseJdbcClient, connection, this.storesUpperCaseIdentifiers(connection));
        }

        private boolean storesUpperCaseIdentifiers(Connection connection) {
            if (this.storesUpperCaseIdentifiers != null) {
                return this.storesUpperCaseIdentifiers;
            }
            try {
                DatabaseMetaData metadata = connection.getMetaData();
                this.storesUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
                return this.storesUpperCaseIdentifiers;
            }
            catch (SQLException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
            }
        }
    }
}

