/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.clickhouse.ClickHouseClient;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;

public class RewriteLike
implements ConnectorExpressionRule<Call, ParameterizedExpression> {
    private static final Capture<Variable> LIKE_VALUE = Capture.newCapture();
    private static final Capture<Constant> LIKE_PATTERN = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.LIKE_FUNCTION_NAME)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.variable().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).matching((variable, context) -> ClickHouseClient.supportsPushdown(variable, (ConnectorExpressionRule.RewriteContext<ParameterizedExpression>)context)).capturedAs(LIKE_VALUE))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.constant().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).capturedAs(LIKE_PATTERN)));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Call expression, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Variable likeValue = (Variable)captures.get(LIKE_VALUE);
        Constant likePattern = (Constant)captures.get(LIKE_PATTERN);
        Preconditions.checkArgument((likePattern.getValue() != null ? 1 : 0) != 0, (Object)"When pattern is NULL, optimizer shortcuts to return fast, not reaching connector expression");
        if (((Slice)likePattern.getValue()).toStringUtf8().contains("\\")) {
            return Optional.empty();
        }
        return context.defaultRewrite((ConnectorExpression)likeValue).flatMap(value -> context.defaultRewrite((ConnectorExpression)likePattern).map(pattern -> new ParameterizedExpression(String.format("%s LIKE %s", value.expression(), pattern.expression()), (List)ImmutableList.builder().addAll((Iterable)value.parameters()).addAll((Iterable)pattern.parameters()).build())));
    }
}

