/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.clickhouse.expression;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.clickhouse.ClickHouseClient;
import io.trino.plugin.jdbc.expression.ComparisonOperator;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class RewriteStringComparison
implements ConnectorExpressionRule<Call, ParameterizedExpression> {
    private static final Capture<ConnectorExpression> LEFT = Capture.newCapture();
    private static final Capture<ConnectorExpression> RIGHT = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.functionName().matching(arg_0 -> ((ImmutableSet)((ImmutableSet)Stream.of(ComparisonOperator.values()).filter(comparison -> comparison != ComparisonOperator.IDENTICAL).map(ComparisonOperator::getFunctionName).collect(ImmutableSet.toImmutableSet()))).contains(arg_0))).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.expression().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).capturedAs(LEFT))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.expression().with(ConnectorExpressionPatterns.type().matching(type -> type instanceof CharType || type instanceof VarcharType)).capturedAs(RIGHT)));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Call expression, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Variable variable;
        ComparisonOperator comparison = ComparisonOperator.forFunctionName((FunctionName)expression.getFunctionName());
        ConnectorExpression leftExpression = (ConnectorExpression)captures.get(LEFT);
        ConnectorExpression rightExpression = (ConnectorExpression)captures.get(RIGHT);
        if (leftExpression instanceof Variable && !ClickHouseClient.supportsPushdown(variable = (Variable)leftExpression, context)) {
            return Optional.empty();
        }
        if (rightExpression instanceof Variable && !ClickHouseClient.supportsPushdown(variable = (Variable)rightExpression, context)) {
            return Optional.empty();
        }
        Optional left = context.defaultRewrite(leftExpression);
        if (left.isEmpty()) {
            return Optional.empty();
        }
        Optional right = context.defaultRewrite(rightExpression);
        if (right.isEmpty()) {
            return Optional.empty();
        }
        Verify.verify((boolean)expression.getFunctionName().getCatalogSchema().isEmpty());
        return Optional.of(new ParameterizedExpression(String.format("(%s) %s (%s)", ((ParameterizedExpression)left.get()).expression(), comparison.getOperator(), ((ParameterizedExpression)right.get()).expression()), (List)ImmutableList.builder().addAll((Iterable)((ParameterizedExpression)left.get()).parameters()).addAll((Iterable)((ParameterizedExpression)right.get()).parameters()).build()));
    }
}

