/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.trace.unsafe;

import com.clickhouse.client.internal.opencensus.trace.ContextHandle;
import com.clickhouse.client.internal.opencensus.trace.ContextManager;
import com.clickhouse.client.internal.opencensus.trace.Span;
import com.clickhouse.client.internal.opencensus.trace.unsafe.ContextHandleImpl;
import com.clickhouse.client.internal.opencensus.trace.unsafe.ContextUtils;
import io.grpc.Context;
import javax.annotation.Nullable;

public class ContextManagerImpl
implements ContextManager {
    @Override
    public ContextHandle currentContext() {
        return ContextManagerImpl.wrapContext(Context.current());
    }

    @Override
    public ContextHandle withValue(ContextHandle contextHandle, @Nullable Span span) {
        return ContextManagerImpl.wrapContext(ContextUtils.withValue(ContextManagerImpl.unwrapContext(contextHandle), span));
    }

    @Override
    public Span getValue(ContextHandle contextHandle) {
        return ContextUtils.getValue(ContextManagerImpl.unwrapContext(contextHandle));
    }

    private static ContextHandle wrapContext(Context context) {
        return new ContextHandleImpl(context);
    }

    private static Context unwrapContext(ContextHandle contextHandle) {
        return ((ContextHandleImpl)contextHandle).getContext();
    }

    protected ContextManagerImpl() {
    }
}

