/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.Sets;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;

class ConcurrentWeakIdentitySet {
    private final Set<Wrapper> set = Sets.newConcurrentHashSet();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    ConcurrentWeakIdentitySet() {
    }

    int size() {
        this.removeStaleEntries();
        return this.set.size();
    }

    boolean add(Object o) {
        this.removeStaleEntries();
        return this.set.add(new Wrapper(o, this.queue));
    }

    private void removeStaleEntries() {
        Reference<Object> o;
        while ((o = this.queue.poll()) != null) {
            this.set.remove((Wrapper)o);
        }
    }

    private static class Wrapper
    extends WeakReference<Object> {
        private final int id;

        private Wrapper(Object o, ReferenceQueue<Object> queue) {
            super(o, queue);
            this.id = System.identityHashCode(o);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Wrapper)) return false;
            Wrapper wrapper = (Wrapper)o;
            if (wrapper.id != this.id) return false;
            return true;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

