/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.client.auth.external.ExternalRedirectStrategy;
import io.trino.client.auth.external.RedirectException;
import io.trino.client.auth.external.RedirectHandler;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class CompositeRedirectHandler
implements RedirectHandler {
    private final List<RedirectHandler> handlers;

    public CompositeRedirectHandler(List<ExternalRedirectStrategy> strategies) {
        this.handlers = (List)Objects.requireNonNull(strategies, "strategies is null").stream().map(ExternalRedirectStrategy::getHandler).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((!this.handlers.isEmpty() ? 1 : 0) != 0, (Object)"Expected at least one external redirect handler");
    }

    @Override
    public void redirectTo(URI uri) throws RedirectException {
        RedirectException redirectException = new RedirectException(String.format("Could not redirect to " + uri, new Object[0]));
        for (RedirectHandler handler : this.handlers) {
            try {
                handler.redirectTo(uri);
                return;
            }
            catch (RedirectException e) {
                redirectException.addSuppressed(e);
            }
        }
        throw redirectException;
    }
}

