/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.uri;

import io.trino.client.uri.PropertyName;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;

interface ConnectionProperty<V, T> {
    default public String getKey() {
        return this.getPropertyName().toString();
    }

    public PropertyName getPropertyName();

    public DriverPropertyInfo getDriverPropertyInfo(Properties var1);

    public boolean isRequired(Properties var1);

    public boolean isValid(Properties var1);

    public Optional<T> getValue(Properties var1) throws SQLException;

    default public T getRequiredValue(Properties properties) throws SQLException {
        return this.getValue(properties).orElseThrow(() -> new SQLException(String.format("Connection property %s is required", this.getKey())));
    }

    public Optional<T> getValueOrDefault(Properties var1, Optional<T> var2) throws SQLException;

    public void validate(Properties var1) throws SQLException;
}

