/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import com.google.common.base.Throwables;
import io.trino.client.auth.external.RedirectException;
import io.trino.client.auth.external.RedirectHandler;
import java.awt.Desktop;
import java.net.URI;

public final class DesktopBrowserRedirectHandler
implements RedirectHandler {
    @Override
    public void redirectTo(URI uri) throws RedirectException {
        try {
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new RedirectException("Desktop Browser is not available. Make sure your Java process is not in headless mode (-Djava.awt.headless=false)");
            }
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf((Throwable)e, RedirectException.class);
            throw new RedirectException("Failed to redirect", e);
        }
    }
}

