/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.DoNotCall;
import io.trino.client.spooling.DataAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DataAttributes {
    final Map<String, Object> attributes;

    DataAttributes(Map<String, Object> attributes) {
        this.attributes = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(attributes, (Object)ImmutableMap.of())));
    }

    public static DataAttributes empty() {
        return new DataAttributes((Map<String, Object>)ImmutableMap.of());
    }

    public <T> T get(DataAttribute attribute, Class<T> clazz) {
        return this.getOptional(attribute, clazz).orElseThrow(() -> new IllegalArgumentException(String.format("Required data attribute '%s' does not exist", attribute.name())));
    }

    public <T> Optional<T> getOptional(DataAttribute attribute, Class<T> clazz) {
        return Optional.ofNullable(this.attributes.get(attribute.attributeName())).map(value -> attribute.decode(clazz, value));
    }

    @JsonProperty(value="attributes")
    public Map<String, Object> toMap() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataAttributes that = (DataAttributes)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributes", this.attributes.keySet()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.attributes);
    }

    @JsonCreator
    @DoNotCall
    public static DataAttributes fromMap(Map<String, Object> attributes) {
        Builder builder = DataAttributes.builder();
        attributes.forEach(builder::set);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataAttributes dataAttributes) {
        return new Builder(dataAttributes);
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();

        private Builder() {
        }

        private Builder(DataAttributes attributes) {
            this.builder.putAll(attributes.attributes);
        }

        public <T> Builder set(DataAttribute attribute, T value) {
            Verify.verify((boolean)attribute.javaClass().isInstance(value), (String)"Invalid value type: %s for attribute: %s", value.getClass(), (Object)attribute.attributeName());
            this.builder.put((Object)attribute.attributeName(), value);
            return this;
        }

        public Builder set(String key, Object value) {
            DataAttribute attribute = DataAttribute.getByName(key);
            return this.set(attribute, attribute.decode(attribute.javaClass(), value));
        }

        public DataAttributes build() {
            return new DataAttributes((Map<String, Object>)this.builder.buildKeepingLast());
        }
    }
}

